package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 官方正在下单营销内容表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinMarketingZhengzai implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 正在下单营销id
     */
    private String zhengzaiId;

    /**
     * 官方营销表id
     */
    private String selfMarketId;

    /**
     * 商铺id
     */
    private String storeId;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 款式id
     */
    private String skuId;

    /**
     * 活动价格
     */
    private BigDecimal priceMarketing;

    /**
     * 活动库存
     */
    private Integer stockMarketing;

    /**
     * 购买限制[0-全部用户|1-仅会员|2-指定用户]
     */
    private String buyFactor;

    /**
     * 购买限制人员名单[购买限制为2-指定用户时必填]
     */
    private String buyRoster;

    /**
     * 限量[0-无限制|X:限购数量]
     */
    private Integer buyLimit;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final GoblinMarketingZhengzai obj = new GoblinMarketingZhengzai();
    public static GoblinMarketingZhengzai getNew() {
        try {
            return (GoblinMarketingZhengzai) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMarketingZhengzai();
        }
    }
}
