package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCertificationParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCompleteParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreCertificationVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtThumbVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtCertificationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@ApiSupport(order = 149001)
@Api(tags = "店铺认证")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt/cert")
public class GoblinStoreMgtCertificationController {
    @Autowired
    IGoblinStoreMgtCertificationService IGoblinStoreMgtCertificationService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "店铺认证第一步:认证资料")
    @PostMapping("fstep")
    public ResponseDto<Object> certificationFirstStep(@Valid @RequestBody GoblinStoreMgtCertificationParam certificationParam) {
        if (log.isDebugEnabled()) {
            log.debug("店铺认证[GoblinStoreMgtCertificationParam:{}]", JsonUtils.toJson(certificationParam));
        }

        IGoblinStoreMgtCertificationService.certificationInformationProcessing(certificationParam);
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "店铺认证第二步:完善信息")
    @PostMapping("sstep")
    public ResponseDto<Object> certificationSecondStep(@Valid @RequestBody GoblinStoreMgtCompleteParam completeParam) {
        if (log.isDebugEnabled()) {
            log.debug("店铺认证[GoblinStoreMgtCompleteParam:{}]", JsonUtils.toJson(completeParam));
        }

        IGoblinStoreMgtCertificationService.certificationCompleteProcessing(completeParam);
        return ResponseDto.success();
    }
}
