package com.liquidnet.service.dragon.channel.alipay.strategy;

import com.liquidnet.service.dragon.channel.alipay.strategy.annotation.StrategyAlipayHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;


/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: Test
 * @Package com.liquidnet.service.dragon.channel.strategy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:27
 */
@Component
public class AlipayStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyAlipayHandler.class);
        AlipayStrategyContext strategyContext = event.getApplicationContext().getBean(AlipayStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyAlipayHandler typeHandler = bean.getClass().getAnnotation(StrategyAlipayHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (IAlipayStrategy) bean);
        });
    }
}