package com.liquidnet.service.goblin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode
public class TempCouponDto implements  Cloneable{
    @ApiModelProperty(position = 1, value = "券名称")
    private String name;
    @ApiModelProperty(position = 2, value = "spuId【无用】")
    private String spuId;
    @ApiModelProperty(position = 4, value = "类型【0-无限|1-一次】")
    private String type;
    @ApiModelProperty(position = 5, value = "优惠价格")
    private BigDecimal value;
    @ApiModelProperty(position = 6, value = "券id")
    private String ucouponId;

    private static final TempCouponDto obj = new TempCouponDto();

    public static TempCouponDto getNew() {
        try {
            return (TempCouponDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new TempCouponDto();
        }
    }
}
