package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileOrganizationService;
import com.liquidnet.client.admin.zhengzai.smile.vo.SmileOrganizationVo;
import com.liquidnet.service.smile.entity.SmileOrganization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Api(tags = "组织管理")
@RestController
@RequestMapping("/smile/organization")
public class SmileOrganizationController {

    @Autowired
    ISmileOrganizationService imsOrganizationService;

    @GetMapping("/organizationList")
    @ApiOperation("获取组织列表")
    @ResponseBody
    public AjaxResult organizationList(){
        List<SmileOrganizationVo> organizationList = imsOrganizationService.organizationList();
        return AjaxResult.success(organizationList);
    }

    @PostMapping("/create")
    @ApiOperation("新增组织")
    @ResponseBody
    public AjaxResult create(@RequestBody SmileOrganization smileOrganization){
        return AjaxResult.success(imsOrganizationService.create(smileOrganization));
    }

    @PostMapping("/updateOrg")
    @ApiOperation("修改组织")
    @ResponseBody
    public AjaxResult updateOrg(@RequestBody SmileOrganization smileOrganization){
        if (imsOrganizationService.update(smileOrganization)){
            return AjaxResult.success();
        }else {
            return AjaxResult.error();
        }
    }

}
