package com.liquidnet.client.admin.zhengzai.smile.vo;

import lombok.*;

import java.time.LocalDate;

@Data
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SmileUserVo {

    private Long id;

    private Long uid;

    /**
     * 照片
     */
    private String img;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 生日YYYY-MM-DD
     */
    private LocalDate birthday;

    /**
     * 性别(1：男（默认），2：女)
     */
    private Integer sex;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 省key
     */
    private String provinceKey;

    /**
     * 省
     */
    private String province;

    /**
     * 市key
     */
    private String cityKey;

    /**
     * 市
     */
    private String city;

    /**
     * 区key
     */
    private String areaKey;

    /**
     * 区
     */
    private String area;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 微信号
     */
    private String wechat;

    /**
     * 代理类型（1：总代，2：普代）
     */
    private Integer type;

    /**
     * 组织关联
     */
    private Long orgId;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 学校ID
     */
    private String schoolId;

    /**
     * 学校名称
     */
    private String schoolName;

    /**
     * 专业
     */
    private String schoolMajor;

    /**
     * 身份（1:在校学生（默认），2已毕业）
     */
    private Integer identity;

    /**
     * 标识步骤
     */
    private String tag;

    /**
     * 认证标识（0:未审核，1：通过，2：未通过）
     */
    private Integer authTag;

    /**
     * 认证失败原因
     */
    private String errorReason;

    /**
     * 1：代理开启，2：代理关闭
     */
    private Integer agent;

    /**
     * 自我介绍
     */
    private String introduce;

    /**
     * 擅长1
     */
    private String specialty1;

    /**
     * 擅长2
     */
    private String specialty2;

    /**
     * 擅长3
     */
    private String specialty3;
}
