package com.liquidnet.service.galaxy.dto.vo.mongo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyOrderFailLogDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/2 15:57
 */
@Data
public class GalaxyNftOrderFailLogVo implements Serializable,Cloneable {
    /**
     * 接入方买入唯一标识
     */
    private String nftOrderPayId;
    /**
     * 用户Id
     */
    private String userId;
    /**
     * 应用系统购买系列唯一ID
     */
    private String nftId;
    /**
     * nft名字
     */
    private String nftName;
    /**
     * 本地系列唯一名称
     */
    private String seriesName;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * 本地系列唯一编码
     */
    private String seriesCode;

    /**
     * 任务Id
     */
    private String taskId;

    /**
     * 失败原因描述
     */
    private String failReasonDesc;

    /**
     * 失败原因描述
     */
    private String failReasonDescSecond;

    /**
     * 处理状态(处理状态 1未处理 2已处理 3再次失败 4不做处理)
     */
    private String dealWithStatus;
    /**
     * nft购买任务id
     * @return
     */
    private String tradeType;

    /**
     * 路由类型
     */
    private String routerType;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;
    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;
    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftOrderFailLogVo obj = new GalaxyNftOrderFailLogVo();

    public static GalaxyNftOrderFailLogVo getNew() {
        try {
            return (GalaxyNftOrderFailLogVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftOrderFailLogVo();
        }
    }
}
