package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryNftInfoReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryNftInfoReqDto", description = "NFT信息查询")
@Data
public class GalaxyQueryNftInfoReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable{
    @ApiModelProperty(position = 1, required = true, value = "nftOrderPayId")
    @NotBlank
    private String nftOrderPayId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryNftInfoReqDto obj = new GalaxyQueryNftInfoReqDto();

    public static GalaxyQueryNftInfoReqDto getNew() {
        try {
            return (GalaxyQueryNftInfoReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryNftInfoReqDto();
        }
    }
}
