package com.liquidnet.service.kylin.service.impl.partner;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.ChildPerformanceDao;
import com.liquidnet.service.kylin.dto.param.CheckPerformanceRelationParam;
import com.liquidnet.service.kylin.dto.param.CheckUserParam;
import com.liquidnet.service.kylin.dto.vo.KylinCheckUserPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinCheckUserPerformances;
import com.liquidnet.service.kylin.mapper.KylinCheckUserPerformancesMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.kylin.service.partner.IKylinCheckUserPerformancesPartnerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 验票用户可看演出表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Service
public class KylinCheckUserPerformancesPartnerServiceImpl extends ServiceImpl<KylinCheckUserPerformancesMapper, KylinCheckUserPerformances> implements IKylinCheckUserPerformancesPartnerService {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private KylinCheckUserPerformancesMapper checkUserPerformancesMapper;

    @Override
    public ResponseDto<PageInfo<ChildPerformanceDao>> childPerformanceList(String merchantId, String checkUserId, int page, int size) {
        PageInfo<ChildPerformanceDao> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<ChildPerformanceDao> data = checkUserPerformancesMapper.childPerformanceList(merchantId, checkUserId);
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<PageInfo<ChildPerformanceDao>> unChildPerformanceList(String merchantId, String checkUserId, int page, int size) {
        PageInfo<ChildPerformanceDao> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<ChildPerformanceDao> data = checkUserPerformancesMapper.unChildPerformanceList(merchantId, checkUserId);
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<String> setPerformance(CheckUserParam param) {
        try {
            List<String> performanceList = new ArrayList<>();
            for (CheckPerformanceRelationParam item : param.getCheckPerformanceRelationParamList()) {
                KylinCheckUserPerformances checkUserPerformances = new KylinCheckUserPerformances();
                checkUserPerformances.setCheckUserId(param.getCheckUserId());
                checkUserPerformances.setCanDownTime(LocalDateTime.parse(item.getCanDownTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                checkUserPerformances.setPerformanceId(item.getPerformanceId());
                checkUserPerformances.setCheckUserPerformanceId(IDGenerator.nextSnowId().toString());
                checkUserPerformances.setCreatedAt(LocalDateTime.now());
                checkUserPerformances.setStatus(1);
                checkUserPerformancesMapper.insert(checkUserPerformances);
                performanceList.add(item.getPerformanceId());
            }
            KylinCheckUserPerformanceVo userPerformanceVo = new KylinCheckUserPerformanceVo();
            userPerformanceVo.setCheckUserId(param.getCheckUserId());
            userPerformanceVo.setPerformanceList(performanceList);
            mongoTemplate.remove(Query.query(Criteria.where("checkUserId").is(param.getCheckUserId())), KylinCheckUserPerformanceVo.class, KylinCheckUserPerformanceVo.class.getSimpleName());
            mongoTemplate.insert(userPerformanceVo, KylinCheckUserPerformanceVo.class.getSimpleName());

            redisUtil.hdel(KylinRedisConst.CHECK_USER_RELATION,param.getCheckUserId());
            return ResponseDto.success("添加成功");
        }catch (Exception e){
            return ResponseDto.failure(ErrorMapping.get(20101));
        }
    }

    @Override
    public ResponseDto<String> delPerformance(List<String> performanceIds, String checkUserId) {
        try {
            List<String> performanceList = new ArrayList<>();
            for (String performanceId : performanceIds) {
                performanceList.add(performanceId);
                checkUserPerformancesMapper.delete(new UpdateWrapper<KylinCheckUserPerformances>().eq("check_user_id", checkUserId).eq("performance_id", performanceId));
            }
            KylinCheckUserPerformanceVo userPerformanceVo = new KylinCheckUserPerformanceVo();
            userPerformanceVo.setCheckUserId(checkUserId);
            userPerformanceVo.setPerformanceList(performanceList);
            mongoTemplate.remove(Query.query(Criteria.where("checkUserId").is(checkUserId)), KylinCheckUserPerformanceVo.class, KylinCheckUserPerformanceVo.class.getSimpleName());
            mongoTemplate.insert(userPerformanceVo, KylinCheckUserPerformanceVo.class.getSimpleName());
            redisUtil.hdel(KylinRedisConst.CHECK_USER_RELATION,checkUserId);
            return ResponseDto.success("删除成功");
        }catch (Exception e){
            return ResponseDto.failure(ErrorMapping.get(20102));
        }
    }
}
