package com.liquidnet.service.kylin.service.partner;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.ChildPerformanceDao;
import com.liquidnet.service.kylin.dto.param.CheckPerformanceRelationParam;
import com.liquidnet.service.kylin.dto.param.CheckUserParam;
import com.liquidnet.service.kylin.entity.KylinCheckUserPerformances;
import com.baomidou.mybatisplus.extension.service.IService;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 验票用户可看演出表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
public interface IKylinCheckUserPerformancesPartnerService extends IService<KylinCheckUserPerformances> {

    // 已配置列表
    ResponseDto<PageInfo<ChildPerformanceDao>> childPerformanceList(String merchantId,String checkUserId,int page,int size);

    // 未配置列表
    ResponseDto<PageInfo<ChildPerformanceDao>> unChildPerformanceList(String merchantId,String checkUserId,int page,int size);

    // 添加配置
    ResponseDto<String> setPerformance(CheckUserParam param);

    // 删除配置
    ResponseDto<String> delPerformance(List<String> performanceIds, String checkUserId);

}
