package com.liquidnet.service.goblin.constant;

public class GoblinRedisConst {
    public static final String PREFIX = "goblin:";
    /* ----------------------------------------------------------------- */
    /**
     * 认证中店铺UID关系缓存
     * {goblin:tmp_uid_store:${uid}, store_id}
     */
    public static final String TMP_UID_STORE = PREFIX.concat("tmp_uid_store:");
    /**
     * 店铺信息
     * {goblin:basic:store:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo}
     */
    public static final String BASIC_STORE = PREFIX.concat("basic:store:");
    /**
     * SPU信息
     * {goblin:basic:goods:${spu_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo}
     */
    public static final String BASIC_GOODS = PREFIX.concat("basic:goods:");
    /**
     * SKU信息
     * {goblin:basic:goods_sku:${sku_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo}
     */
    public static final String BASIC_GOODS_SKU = PREFIX.concat("basic:goods_sku:");




    /* ----------------------------------------------------------------- */
    public static final String FRONT_BANNER = PREFIX.concat("front_banner");  //前端banner
    public static final String FRONT_NAVIGATION = PREFIX.concat("front_navigation");  //前端banner
    public  static final String FRONT_HOTWORD = PREFIX.concat("front_hot_word");  //前端banner
    public  static final String FRONT_HOTWORD_INDEX = PREFIX.concat("front_hot_word_index");  //前端banner index
    public  static final String FRONT_FRONT_SECKILL = PREFIX.concat("front_front_seckill");  //前端 首页秒杀
    public  static final String FRONT_SECKILL = PREFIX.concat("front_seckill");  //前端 秒杀列表
    public  static final String SELECT_GOODS = PREFIX.concat("select_goods");  //精选商品


    /* ----------------------------------------------------------------- */
    public static final String REDIS_GOBLIN_MARKET_RELATION = PREFIX.concat("market:relation:");//商铺活动-商铺款式关联关系
    public static final String REDIS_GOBLIN_SELF_MARKET = PREFIX.concat("self:market:");//官方活动
    public static final String REDIS_GOBLIN_ZHENGZAI_RELATION = PREFIX.concat("zhengzai:market:");//活动-正在下单-可参加商户
    public static final String REDIS_GOBLIN_STORE_SELF_RELATION = PREFIX.concat("zhengzai:storeId:");//活动-当前商铺能参与的官方活动id列表
    public static final String REDIS_GOBLIN_STORE_MARKET = PREFIX.concat("store:market:");//商铺活动
    public static final String REDIS_GOBLIN_ZHENGZAI_LIST = PREFIX.concat("zhengzai:list");//全部正在下单内容

    public static final String REDIS_GOBLIN_STORE_MARKET_ISCONFIG = PREFIX.concat("store:is_config:");//商铺活动-该活动配置了款式的商品

    public static final String REDIS_GOBLIN_BUY_COUNT = PREFIX.concat("uid:");//用户sku购买数量 key:uid:skuId:$skuId
    public static final String REDIS_GOBLIN_SALE_COUNT = PREFIX.concat("sale:skuId:");//用户sku购买数量 key:sale:skuId:$skuId
    /* ----------------------------------------------------------------- */
    /**
     * SKU剩余库存
     */
    public static final String REAL_STOCK_SKU = PREFIX.concat("real_stock_sku:");
    /* ----------------------------------------------------------------- */
}
