package com.liquidnet.service.kylin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PayAgainParam;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderParam;
import com.liquidnet.service.kylin.dto.vo.returns.*;

import java.util.HashMap;

/**
 * <p>
 * 订单 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
public interface IKylinOrderTicketsOrderService {

    // 下单前判断接口(判断是否可锁定库存)(无订单->待支付->可支付)
    ResponseDto<PayInnerResultVo> checkCanOrder(PayOrderParam payOrderParam);

    // 再次支付(待支付->可支付->倒计时结束释放库存)
    ResponseDto<PayInnerResultVo> payAgain(PayAgainParam payAgainParam);

    // 支付回调(待支付->已支付->中断倒计时)
    String syncOrder(SyncOrderParam syncOrderParam);

    //去 PHP pay检查 订单状态
    ResponseDto<HashMap<String,Object>> checkOrderResult(String orderId);

}
