package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.PerformancesExpressServiceImpl;
import com.liquidnet.service.kylin.dao.PerformanceExpressAdminListDao;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressAdminListParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 演出快递
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-21
 */

@Controller
@RequestMapping("/kylin/performancesExpress")
public class PerformancesExpressController extends BaseController {

    private String prefix = "zhengzai/kylin/performancesExpress";

    @Value("${liquidnet.shunfeng.url}")
    private String url;
    @Value("${liquidnet.shunfeng.sk}")
    private String sk;
    @Value("${liquidnet.shunfeng.appid}")
    private String appid;

    @Autowired
    private PerformancesExpressServiceImpl performancesExpressServiceImpl;

    @RequiresPermissions("kylin:performancesExpress:view")
    @GetMapping()
    public String banners() {
        return prefix + "/performancesExpress";
    }

    /**
     * 查询演出列表
     */
    @RequiresPermissions("kylin:performances:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(PerformanceExpressAdminListParam performanceExpressAdminListParam) {
        List<PerformanceExpressAdminListDao> result = performancesExpressServiceImpl.getList(performanceExpressAdminListParam);
        return getDataTable(result);
    }

}
