package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinStoreCertificationService;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinStoreInfoService;
import com.liquidnet.service.goblin.entity.GoblinStoreCertification;
import com.liquidnet.service.goblin.entity.GoblinStoreInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

@Api(tags = "店铺管理")
@Controller
@RequestMapping("goblin/store")
public class GoblinStoreAdminController extends BaseController {
    private final String prefix = "zhengzai/goblin/store";
    @Autowired
    IGoblinStoreInfoService goblinStoreInfoService;
    @Autowired
    IGoblinStoreCertificationService goblinStoreCertificationService;

    @GetMapping()
    public String store() {
        return prefix + "/store";
    }

    @RequiresPermissions("goblin:store:list")
    @RequestMapping("/list")
    @ResponseBody
    public TableDataInfo list(GoblinStoreInfo storeInfo) {
        LambdaQueryWrapper<GoblinStoreInfo> lambdaQueryWrapper = Wrappers.lambdaQuery(GoblinStoreInfo.class);
        if (StringUtils.isNotBlank(storeInfo.getStatus())) {
            lambdaQueryWrapper.eq(GoblinStoreInfo::getStatus, storeInfo.getStatus());
        }
        if (StringUtils.isNotBlank(storeInfo.getStoreName())) {
            lambdaQueryWrapper.like(GoblinStoreInfo::getStoreName, storeInfo.getStoreName());
        }
        if (StringUtils.isNotBlank(storeInfo.getCertType())) {
            lambdaQueryWrapper.eq(GoblinStoreInfo::getCertType, storeInfo.getCertType());
        }
        lambdaQueryWrapper.eq(GoblinStoreInfo::getDelFlg, "0");
        lambdaQueryWrapper.notIn(GoblinStoreInfo::getStatus, "0");

        lambdaQueryWrapper.select(
                GoblinStoreInfo::getStoreId,
                GoblinStoreInfo::getStoreName,
                GoblinStoreInfo::getCertType,
                GoblinStoreInfo::getStatus
        );
        startPage();
        return getDataTable(goblinStoreInfoService.list(lambdaQueryWrapper));
    }

    @RequiresPermissions("goblin:store:info")
    @GetMapping("info/{storeId}")
    public String info(@PathVariable("storeId") String storeId, ModelMap mmap) {
        LambdaQueryWrapper<GoblinStoreInfo> storeInfoLambdaQueryWrapper = Wrappers.lambdaQuery(GoblinStoreInfo.class);
        storeInfoLambdaQueryWrapper.eq(GoblinStoreInfo::getStoreId, storeId);

        storeInfoLambdaQueryWrapper.select(
                GoblinStoreInfo::getStoreId,
                GoblinStoreInfo::getStoreName,
                GoblinStoreInfo::getLogoPic,
                GoblinStoreInfo::getBackgroundPic,
                GoblinStoreInfo::getIntroduce,
                GoblinStoreInfo::getStatus,
                GoblinStoreInfo::getReason,
                GoblinStoreInfo::getStoreType,
                GoblinStoreInfo::getCertType,
                GoblinStoreInfo::getAveScore,
                GoblinStoreInfo::getServiceAcc,
                GoblinStoreInfo::getValidity
        );
        mmap.put("storeInfo", goblinStoreInfoService.getOne(storeInfoLambdaQueryWrapper));

        LambdaQueryWrapper<GoblinStoreCertification> storeCertificationLambdaQueryWrapper = Wrappers.lambdaQuery(GoblinStoreCertification.class);
        storeCertificationLambdaQueryWrapper.eq(GoblinStoreCertification::getStoreId, storeId);

        storeCertificationLambdaQueryWrapper.select(
                GoblinStoreCertification::getPersonCertType,
                GoblinStoreCertification::getPersonName,
                GoblinStoreCertification::getPersonCertCode,
                GoblinStoreCertification::getPersonCertValidity,
                GoblinStoreCertification::getPersonCertLasting,
                GoblinStoreCertification::getPersonCertFpic,
                GoblinStoreCertification::getPersonCertBpic,
                GoblinStoreCertification::getPersonCertSpic,
                GoblinStoreCertification::getProvinceId,
                GoblinStoreCertification::getProvinceName,
                GoblinStoreCertification::getCityId,
                GoblinStoreCertification::getCityName,
                GoblinStoreCertification::getCountyId,
                GoblinStoreCertification::getCountyName,
                GoblinStoreCertification::getBusAddress,
                GoblinStoreCertification::getBusName,
                GoblinStoreCertification::getBusCertCode,
                GoblinStoreCertification::getBusCertValidity,
                GoblinStoreCertification::getBusCertLasting,
                GoblinStoreCertification::getBusCertPic,
                GoblinStoreCertification::getBusQualityPic
        );
        mmap.put("storeCertification", goblinStoreCertificationService.getOne(storeCertificationLambdaQueryWrapper));
        return prefix + "/info";
    }

    @Log(title = "店铺管理:店铺审核:通过", businessType = BusinessType.UPDATE)
    @RequiresPermissions("goblin:store:audit:accept")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]")
    })
    @PostMapping("audit/accept")
    @ResponseBody
    public AjaxResult audit(String storeId) {
        try {
            return this.toAjax(goblinStoreInfoService.audit(storeId, String.valueOf(3), ShiroUtils.getLoginName(), null));
        } catch (Exception e) {
            return toAjax(false);
        }
    }

    @Log(title = "店铺管理:店铺审核:驳回", businessType = BusinessType.UPDATE)
    @RequiresPermissions("goblin:store:audit:reject")
    @PostMapping("audit/reject")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "reason", value = "拒绝原因[256]"),
    })
    @ResponseBody
    public AjaxResult reject(String storeId, String reason) {
        try {
            return this.toAjax(goblinStoreInfoService.audit(storeId, String.valueOf(2), ShiroUtils.getLoginName(), reason));
        } catch (Exception e) {
            return toAjax(false);
        }
    }

    /** ------------------------------------------------------------------------ **/
}
