package com.liquidnet.service.feign.kylin.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinPerformanceVo;
import feign.hystrix.FallbackFactory;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-kylin",
        contextId = "FeignKylinOrderRefundClient", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignKylinOrderRefundClient {

    @PostMapping("admin/refund/apply")
    ResponseDto<Object> refundApply(
            @RequestBody String orderTicketsId,
            @RequestBody String orderRefundBatchesId,
            @RequestBody String refundData,
            @RequestBody String reason
    );

    @PostMapping("admin/refund/cancel")
    @ApiOperation("取消退款")
    ResponseDto<Object> refundApply(@RequestBody List orderRefundsIdList);

    @PostMapping("admin/refund/reapply")
    @ApiOperation("再次提交审核")
    ResponseDto<Object> refundReapply(@RequestBody List orderRefundsIdList);

    @PostMapping("admin/refund/review")
    @ApiOperation("一审运营 审核/驳回")
    ResponseDto<Object> refundReview(@RequestBody List orderRefundsIdList, @RequestBody Integer status, @RequestBody String reject);

    @PostMapping("admin/refund/execute")
    @ApiOperation("二审财务 审核(执行退款)/驳回")
    ResponseDto<Object> refundExecute(@RequestBody List orderRefundsIdList, @RequestBody Integer status, @RequestBody String refuse);
}
