package com.liquidnet.service.platform.service.impl.goblin;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExActivityVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExSkuVo;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import com.liquidnet.service.goblin.entity.GoblinNftExSku;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExSkuMapper;
import com.liquidnet.service.goblin.param.GoblinNftExSkuParam;
import com.liquidnet.service.goblin.service.IGoblinNftExSkuService;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import com.liquidnet.service.platform.utils.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: wll
 * @Description: nft兑换活动和和sku的关联
 * @Date:Create：in 2022/4/19 5:14 下午
 */

@Service
@Slf4j
public class GoblinNftExSkuServiceImpl implements IGoblinNftExSkuService {

    @Autowired
    private GoblinNftExCodeMapper goblinNftExCodeMapper;
    @Autowired
    private GoblinNftExSkuMapper goblinNftExSkuMapper;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;


    @Transactional
    @Override
    public Boolean add(List<GoblinNftExSkuParam> goblinNftExSkuParams) {

        LocalDateTime now = LocalDateTime.now();

/*        ArrayList<GoblinNftExSkuVo> goblinNftExSkuArrayList = ObjectUtil.getGoblinNftExSkuArrayList();
        ArrayList<GoblinNftExCodeVo> goblinNftExCodeArrayList = ObjectUtil.getGoblinNftExCodeArrayList();*/

        List<GoblinNftExSku> goblinNftExSkus = new ArrayList<>();
        List<GoblinNftExCode> goblinNftExCodes = new ArrayList<>();

        String activityId = "";

        // 构建对象
        for (GoblinNftExSkuParam goblinNftExSkuParam : goblinNftExSkuParams) {
            if (StringUtil.isBlank(activityId)) {
                activityId = goblinNftExSkuParam.getActivityId();
            }
            GoblinNftExSku goblinNftExSku = new GoblinNftExSku();
            BeanUtils.copyProperties(goblinNftExSkuParam, goblinNftExSku);
            goblinNftExSku.setCreatedAt(now);
            // 构建兑换码数量
            for (int i = 0; i < goblinNftExSkuParam.getExStock(); i++) {
                GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
                goblinNftExCode.setCodeId(IDGenerator.nextSnowId());
                goblinNftExCode.setActivityId(goblinNftExSkuParam.getActivityId());
                // 获取code码
                // 样例 2978-6496-9269-0694-XX

                goblinNftExCode.setCode("");
                goblinNftExCode.setSkuId(goblinNftExSkuParam.getSkuId());
                goblinNftExCode.setState(1);
                goblinNftExCode.setCreatedAt(now);
                goblinNftExCodes.add(goblinNftExCode);
                // goblinNftExCodeArrayList.add(GoblinNftExCodeVo.getNew().copy(goblinNftExCode));
            }

            goblinNftExSkus.add(goblinNftExSku);
            // goblinNftExSkuArrayList.add(GoblinNftExSkuVo.getNew().copy(goblinNftExSku));
        }
        goblinNftExSkuMapper.addGoblinNftExSkus(goblinNftExSkus);
        goblinNftExCodeMapper.addGoblinNftExCodes(goblinNftExCodes);
        return true;
    }

    /**
     *
     * @function 生成num位的随机字符串(数字、大写字母随机混排)
     * @param num
     * @return
     */
    public static String createBigSmallLetterStrOrNumberRadom(int num) {

        StringBuffer str = new StringBuffer();
        for (int k=0;k<num;k++) {
            for(int i=0;i < 4;i++){
                int intVal=(int)(Math.random()*58+65);
                if(intVal >= 91 && intVal <= 96){
                    i--;
                }
                if(intVal < 91 || intVal > 96){
                    if(intVal%2==0){
                        str.append((char)intVal);
                    }else{
                        str.append((int)(Math.random()*10));
                    }
                }
            }
            str.append("-");
        }

        return str.toString()+"CH";
    }

    public static void main(String[] args) {
        System.out.println(createBigSmallLetterStrOrNumberRadom(3));
    }


}
