package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 预约表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsAnticipateVo implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private String id;

    /**
     * 预约名称
     */
    private String name;

    /**
     * ant_id
     */
    private String antId;

    /**
     * 配置人数
     */
    @ApiModelProperty(value = "预约人数（达到一定人数可以预约）")
    private Integer people;

    /**
     * 类型标识
     */
    @ApiModelProperty(value = "预约类型（1：预约提醒，2：预约获得购买资格）")
    private int type;

    /**
     * 预约规则
     */
    @ApiModelProperty(value = "预约规则")
    private String rule;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdDate;
    /**
     * 删除（0:未删除1:已删除）
     */
    @ApiModelProperty(value = "删除（0:未删除1:已删除）")
    private Integer delTag;

    @ApiModelProperty(value = "目前三种状态（0:未开始，1:预约中，2:已结束）")
    private Integer state;

    private static final GoblinGoodsAnticipateVo obj = new GoblinGoodsAnticipateVo();

    public static GoblinGoodsAnticipateVo getNew() {
        try {
            return (GoblinGoodsAnticipateVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsAnticipateVo();
        }
    }

    public GoblinGoodsAnticipateVo copy(GoblinGoodsAnticipateAddParam goodsAnticipateAddParam) {
        if (null==goodsAnticipateAddParam) return this;
        this.name = goodsAnticipateAddParam.getName();
        this.people = goodsAnticipateAddParam.getPeople();
        this.type = goodsAnticipateAddParam.getType();
        this.setRule(goodsAnticipateAddParam.getRule());
        return this;
    }
}
