package com.liquidnet.service.merchant.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 演出授权关联权限表
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MerchantAuthorizationPermissions implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * authorization_permission_id
     */
    private String authorizationPermissionId;

    /**
     * authorization_record_id
     */
    private String authorizationRecordId;

    /**
     * permission_id
     */
    private String permissionId;

    /**
     * 授权开始时间
     */
    private LocalDateTime startTime;

    /**
     * 授权结束时间
     */
    private LocalDateTime endTime;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
