package com.liquidnet.service.adam.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.service.adam.dto.vo.AdamCollectBaseVo;
import com.liquidnet.service.adam.dto.vo.AdamCollectInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamCollectVo;
import com.liquidnet.service.adam.service.IAdamCollectionService;
import com.liquidnet.service.adam.service.IAdamRdmService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.feign.kylin.api.FeignKylinPerformanceClient;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 收藏 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Slf4j
@Service
public class AdamCollectionServiceImpl implements IAdamCollectionService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    IAdamRdmService adamRdmService;

    /* ---------------- 外部服务API ---------------- */
    @Autowired
    FeignKylinPerformanceClient feignKylinPerformanceClient;

    @Override
    public void add(AdamCollectBaseVo vo) {
        LocalDateTime now = LocalDateTime.now();

        vo.setState(1);
        vo.setCreatedAt(now);

        mongoTemplate.insert(vo, AdamCollectBaseVo.class.getSimpleName());

        rabbitTemplate.convertSendAndReceive(MQConst.EX_LNS_SQL_UCENTER, MQConst.RK_SQL_UCENTER,
                SqlMapping.get("adam_collection.add",
                        vo.getUid(), vo.getContentId(), vo.getType(), vo.getState(), now
                )
        );
    }

    @Override
    public AdamCollectBaseVo query(String uid, String type, String contentId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                        .and("contentId").is(contentId).and("state").is(1)),
                AdamCollectBaseVo.class, AdamCollectBaseVo.class.getSimpleName());
    }

    @Override
    public void del(String uid, String type, String... contentIds) {
        LocalDateTime now = LocalDateTime.now();

//        AdamCollectBaseVo delVo = AdamCollectBaseVo.getNew();
//        delVo.setState(2);
//        delVo.setUpdatedAt(now);

        UpdateResult updateResult = mongoTemplate.getCollection(AdamCollectBaseVo.class.getSimpleName()).updateMany(
                Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                        .and("contentId").in(contentIds).and("state").is(1)).getQueryObject(),
                new Document("$set", new Document("state", 2).append("updatedAt", now)));
        if (updateResult.getModifiedCount() > 0) {
            LinkedList<Object[]> toMqObjs = new LinkedList<>();
            for (String c : contentIds) {
                toMqObjs.add(new Object[]{now, uid, c});
            }
            rabbitTemplate.convertSendAndReceive(MQConst.EX_LNS_SQL_UCENTER, MQConst.RK_SQL_UCENTER,
                    SqlMapping.get("adam_collection.del", toMqObjs));
        }
    }

    @Override
    public boolean queryState(String uid, String type, String contentId) {
        long count = mongoTemplate.count(Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                .and("contentId").is(contentId).and("state").is(1)), AdamCollectBaseVo.class.getSimpleName());
        return count > 0;
    }

    @Override
    public PageInfo<AdamCollectVo> queryPage(String uid, String type, int pageNo, int pageSize) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("type").is(type).and("state").is(1));

        long count = mongoTemplate.count(query, AdamCollectBaseVo.class.getSimpleName());

        PageInfo<AdamCollectVo> voPageInfo = null;
        if (count > 0) {
            Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "createdAt"));

            query.with(pageable);

            List<AdamCollectVo> collectVoList = mongoTemplate.find(query, AdamCollectVo.class, AdamCollectBaseVo.class.getSimpleName());

            try {
                String[] contentIds = collectVoList.stream().map(AdamCollectVo::getContentId).toArray(a -> new String[collectVoList.size()]);

                ResponseDto<List<KylinPerformanceVo>> performanceVoListDto = feignKylinPerformanceClient.performanceList(contentIds);

                if (performanceVoListDto.isSuccess()) {
                    List<KylinPerformanceVo> kylinPerformanceVoList = performanceVoListDto.getData();

                    collectVoList.forEach(v -> {
                        kylinPerformanceVoList.forEach(vl -> {
                            if (vl.getPerformancesId().equals(v.getContentId())) {
                                AdamCollectInfoVo collectInfoVo = AdamCollectInfoVo.getNew();
                                BeanUtils.copyProperties(vl, collectInfoVo);
                                v.setContentInfo(collectInfoVo);
                            }
                        });
                    });
                } else {
                    log.info("Failed:{}.API.performanceList(...) for AdamCollection:{}", feignKylinPerformanceClient.getClass().getSimpleName(), performanceVoListDto.toJson());
                }
            } catch (Exception e) {
                log.error("Exception:{}.API.performanceList(...) for AdamCollection", feignKylinPerformanceClient.getClass().getSimpleName(), e);
            }
            voPageInfo = PageInfo.of(collectVoList);
            voPageInfo.setTotal(count);
        } else {
            voPageInfo = new PageInfo<>();
        }

        return voPageInfo;
    }
}
