package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 票
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinTickets implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * tickets_id
     */
    private String ticketsId;

    /**
     * 票名称
     */
    private String title;

    /**
     * 票类型 1单日票 2通票
     */
    private Integer type;

    /**
     * 票单价
     */
    private BigDecimal price;

    /**
     * 快递费
     */
    private BigDecimal priceExpress;

    /**
     * 会员优惠价格
     */
    private BigDecimal priceDiscountMember;

    /**
     * 优惠价格
     */
    private BigDecimal priceDiscount;

    /**
     * 票种描述
     */
    private String describes;

    /**
     * 快递票类型说明
     */
    private String describeExpress;

    /**
     * 电子票票类型说明
     */
    private String describeElectronic;

    /**
     * 会员提前购买分钟数
     */
    private Integer advanceMinuteMember;

    /**
     * 售卖开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 售卖结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 快递票结束时间
     */
    private LocalDateTime timeEndExpress;

    /**
     * 适用开始时间
     */
    private LocalDateTime useStart;

    /**
     * 适用结束时间
     */
    private LocalDateTime useEnd;

    /**
     * 支付倒计时时间
     */
    private Integer payCountdownMinute;

    /**
     * 开票提醒倒计时（分钟数）
     */
    private Integer saleRemindMinute;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinTickets obj = new KylinTickets();
    public static KylinTickets getNew() {
        try {
            return (KylinTickets) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinTickets();
        }
    }

    public Object[] insert(KylinTickets vo) {
        return new Object[]{
                vo.getTicketsId(),vo.getTitle(),vo.getType(),
                vo.getPrice(),vo.getPriceExpress(),vo.getPriceDiscountMember(),
                vo.getPriceDiscount(),vo.getDescribes(),vo.getDescribeExpress(),
                vo.getDescribeElectronic(),vo.getAdvanceMinuteMember(),
                vo.getTimeStart(),vo.getTimeEnd(),vo.getTimeEndExpress(),
                vo.getUseStart(),vo.getUseEnd(),vo.getPayCountdownMinute(),
                vo.getSaleRemindMinute(),vo.getComment(),vo.getCreatedAt(),
                vo.getUpdatedAt()
        };
    }
}
