package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 票
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinTicketRelations implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * ticket_relations_id
     */
    private String ticketRelationsId;

    /**
     * 票关联id
     */
    private String ticketId;

    /**
     * 关联场次id
     */
    private String timesId;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinTicketRelations obj = new KylinTicketRelations();
    public static KylinTicketRelations getNew() {
        try {
            return (KylinTicketRelations) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinTicketRelations();
        }
    }
}
