package com.liquidnet.service.goblin.dto.manage;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 * 预约关联sku和spu表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-08
 */
@ApiModel(value = "GoblinGoodsAnticipateParam", description = "创建关联sku和spu表")
@Data
public class GoblinGoodsAnticipateValueAddParam {

    private static final long serialVersionUID = 1L;

    /**
     * sku名称
     */
    @ApiModelProperty(value = "sku名称")
    @NotBlank(message = "skuName不能为空")
    private String skuName;

    /**
     * sku_id 对应 goblin_goods_sku.sku_id
     */
    @ApiModelProperty(value = "sku_id 对应 goblin_goods_sku.sku_id")
    @NotBlank(message = "skuId不能为空")
    private String skuId;

    /**
     * spu_id对应 goblin_goods_spu_id
     */
    @ApiModelProperty(value = "spu_id对应 goblin_goods_spu_id")
    @NotBlank(message = "spuId不能为空")
    private String spuId;

    /**
     * 预约开始时间
     */
    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @NotBlank(message = "预约开始时间不能为空")
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @NotBlank(message = "预约结束时间不能为空")
    private LocalDateTime aboutEndDate;

    /**
     * 删除（0:未删除1:已删除）
     */
//    @ApiModelProperty(value = "修改传入参数 创建不传 删除（0:未删除1:已删除）")
//    private Integer delTag;

}
