package com.liquidnet.common.mq.constant;


import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:guo_xp@163.com">guoxinpeng</a>
 * @version 1.0 2016/11/21 9:45
 * @projectname repayment
 * @packname com.liquidnet.service.repayment.constant
 */
public enum ResultType {
  PROCESSING("PROCESSING"),SUCCESS("SUCCESS"), ERROR("ERROR"), PARAMETERS_ERROR("PARAMETERS_ERROR"), USAGE_UNAVAILABLE_AMOUNT("USAGE_UNAVAILABLE_AMOUNT"), FROZEN_UNAVAILABLE_AMOUNT("FROZEN_UNAVAILABLE_AMOUNT"), ORDER_ERROR("ORDER_ERROR");
  private String desc;

  private ResultType(String desc) {
    this.desc = desc;
  }

  public String getDesc() {
    return this.desc;
  }

  private static final Map<String, ResultType> typeMap;

  static {
    Map<String, ResultType> resultTypeMap = new HashMap<>();
    for (ResultType resultType : ResultType.values()) {
      resultTypeMap.put(resultType.desc, resultType);
    }
    typeMap = Collections.unmodifiableMap(resultTypeMap);
  }

  public static ResultType getResultType(String desc) {
    return typeMap.get(desc);
  }
}
