package com.liquidnet.service.platform.utils;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesTicketCreatePartnerVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.platform.service.impl.partner.KylinTicketTimesPartnerServiceImpl;
import com.liquidnet.service.platform.service.impl.partner.KylinTicketsPartnerServiceImpl;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@Component
@Slf4j
public class PerformanceVoTask {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MongoVoUtils mongoVoUtils;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;

    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @Autowired
    private KylinTicketsMapper ticketsMapper;

    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;

    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;

    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;


    /**
     * 根据票状态判断 演出状态 票状态
     *
     * @param performanceSingleId
     */
    public void performanceVoStatus(String performanceSingleId) {
        LocalDateTime timeNow = LocalDateTime.now();
        List<String> performanceIdList = new ArrayList<>();

        if (performanceSingleId == null) {
            List<KylinPerformanceStatus> list = performanceStatusMapper.selectList(new UpdateWrapper<KylinPerformanceStatus>().in("status", 6, 8, 9));
            for (KylinPerformanceStatus item : list) {
                performanceIdList.add(item.getPerformanceId());
            }
        } else {
            performanceIdList.add(performanceSingleId);
        }

        for (String performancesId : performanceIdList) {
            KylinPerformanceVo vo = mongoVoUtils.combinePerformanceVoData(performancesId);
            //场次
            List<KylinTicketTimesVo> timesData = vo.getTicketTimeList();
            if (timesData.size() == 0) {
                continue;
            }
            int ticketCount = 0;            //总循环次数
            int status9Count = 0;            //未开售次数
            int status8Count = 0;            //售罄次数
            int status10Count = 0;            //已结束次数

            //演出数据
            int appStatus = 6;
            for (KylinTicketTimesVo kylinTicketTimesVoItem : timesData) {
                //票
                List<KylinTicketVo> kylinTicketVoList = kylinTicketTimesVoItem.getTicketList();
                ticketCount += kylinTicketVoList.size();
                for (KylinTicketVo kylinTicketVoItem : kylinTicketVoList) {
                    //时间判断
                    LocalDateTime timeStart = DateUtil.Formatter.yyyyMMddHHmmss.parse(kylinTicketVoItem.getMemberTimeStart());
                    LocalDateTime timeEnd = DateUtil.Formatter.yyyyMMddHHmmss.parse(kylinTicketVoItem.getTimeEnd());
                    int surplusGeneral = -1;
                    int status = 0;
                    if (timeStart.isAfter(timeNow)) {
                        //未开始
                        status = 9;
                        status9Count += 1;
                    } else if (timeEnd.isBefore(timeNow)) {
                        //结束
                        status = 10;
                        status10Count += 1;
                    } else {
                        //库存判断
                        surplusGeneral = dataUtils.getSurplusGeneral(kylinTicketVoItem.getTicketsId());
                        if (surplusGeneral > 0) {
                            status = 6;
                        } else {
                            status = 8;
                            status8Count += 1;
                        }
                    }

                    if (kylinTicketVoItem.getStatus() == 7) {
                        status = 7;
                    }

                    //修改票状态
                    KylinTicketStatus changeStatus = new KylinTicketStatus();
                    changeStatus.setStatus(status);
                    if (surplusGeneral != -1) {
                        changeStatus.setSurplusGeneral(surplusGeneral);
                    }
                    ticketStatusMapper.update(changeStatus, new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", kylinTicketVoItem.getTicketsId()));
                    kylinTicketVoItem.setStatus(status);

                    //演出状态
                    if (status == 6) {//单一票 可购买 则为可购买
                        appStatus = 6;
                    } else if (ticketCount == status10Count) {//全票结束 为结束
                        appStatus = 10;
                    } else if (ticketCount == status8Count) {//全票售罄为售罄
                        appStatus = 8;
                    } else if (ticketCount == status9Count) {//全票未开始 为未开始
                        appStatus = 9;
                    }
                }
            }
            if (vo.getAppStatus() <= 4) {
                appStatus = vo.getAppStatus();
            }
            if (vo.getAppStatus() == 7) {
                appStatus = 7;
            }
            //修改演出状态
            KylinPerformanceStatus changeStatus = new KylinPerformanceStatus();
            changeStatus.setStatus(appStatus);
            performanceStatusMapper.update(changeStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
            vo.setAppStatus(appStatus);
            dataUtils.updatePerformanceMongo(performancesId, vo);
        }
    }


    /**
     * 生成 PerformanceCreatePartnerVo(用于审核第一次提交数据)
     *
     * @param performancesId
     * @return
     */
    public KylinPerformanceMisVo getPerformanceMisVo(String performancesId) {
        try {
            PerformancePartnerVo performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
            List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            List<TicketTimesTicketCreatePartnerVo> ticketTimesTicketCreatePartnerVoList = new ArrayList<TicketTimesTicketCreatePartnerVo>();

            ArrayList<BigDecimal> floatList = new ArrayList<>();
            ArrayList<String> StringList = new ArrayList<>();

            for (KylinTicketTimesPartnerVo ticketTimes : kylinTicketTimesPartnerVos) {
                TicketTimesTicketCreatePartnerVo ticketTimesTicketCreatePartnerVo = new TicketTimesTicketCreatePartnerVo();
                BeanUtils.copyProperties(ticketTimes, ticketTimesTicketCreatePartnerVo);
                List<KylinTicketPartnerVo> kylinTicketPartnerVos = ticketsPartnerService.getTicketMongoList(ticketTimes.getTicketTimesId());
                ticketTimesTicketCreatePartnerVo.setTicket(kylinTicketPartnerVos);
                ticketTimesTicketCreatePartnerVoList.add(ticketTimesTicketCreatePartnerVo);
                for (KylinTicketPartnerVo kylinTicketPartnerVoItem : kylinTicketPartnerVos) {
                    floatList.add(kylinTicketPartnerVoItem.getPrice());
                    StringList.add(kylinTicketPartnerVoItem.getTimeEnd());
                }
            }
            KylinPerformanceMisVo kylinPerformanceMisVo = new KylinPerformanceMisVo();
            BeanUtils.copyProperties(performanceData, kylinPerformanceMisVo);

            floatList.sort(Comparator.naturalOrder());
            StringList.sort(Comparator.naturalOrder());

            kylinPerformanceMisVo.setPrice(floatList.get(0) + "起");
            kylinPerformanceMisVo.setStopSellTime(StringList.get(0));
            kylinPerformanceMisVo.setTicketTimes(ticketTimesTicketCreatePartnerVoList);

            kylinPerformanceMisVo.setIsDistribution(0);
            kylinPerformanceMisVo.setSyncAgent(0);
            kylinPerformanceMisVo.setAuditStatus(0);

            return kylinPerformanceMisVo;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 插入数据库
     *
     * @param performancesId
     * @param map
     * @param kylinPerformanceMisVo
     * @param updatedAt
     */
    public void createPerformanceMySql(String performancesId, HashMap<String, Object> map, KylinPerformanceMisVo kylinPerformanceMisVo, LocalDateTime updatedAt) {
        try {
            //创建演出
            KylinPerformances performances = new KylinPerformances();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performances);
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performanceStatus);
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performanceRelations);

            performances.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getCreatedAt())));
            performances.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getTimeStart())));
            performances.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getTimeEnd())));
            performances.setCityName((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + performanceRelations.getFieldId(), "city_name"));
            performances.setCityId(Integer.parseInt((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + performanceRelations.getFieldId(), "city_id")));
            performances.setUpdatedAt(updatedAt);

            performanceStatus.setPerformanceId(performances.getPerformancesId());
            performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
            performanceStatus.setCreatedAt(performances.getCreatedAt());
            performanceStatus.setAuditStatus(0);
            performanceStatus.setUpdatedAt(updatedAt);

            performanceStatus.setLimitCountMember(1);

            performanceRelations.setPerformanceId(performances.getPerformancesId());
            performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
            performanceRelations.setCreatedAt(performances.getCreatedAt());
            performanceRelations.setUpdatedAt(updatedAt);

            performancesMapper.delete(new UpdateWrapper<KylinPerformances>().eq("performances_id", performances.getPerformancesId()));
            performancesMapper.insert(performances);
            performanceStatusMapper.delete(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performanceStatus.getPerformanceId()));
            performanceStatusMapper.insert(performanceStatus);
            performanceRelationsMapper.delete(new UpdateWrapper<KylinPerformanceRelations>().eq("performance_id", performanceRelations.getPerformanceId()));
            performanceRelationsMapper.insert(performanceRelations);


            //场次数据
            List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (KylinTicketTimesPartnerVo ticketTimeItem : kylinTicketTimesPartnerVos) {
                //创建场次
                KylinTicketTimes ticketTimes = new KylinTicketTimes();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimes);
                KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimeRelation);

                ticketTimes.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                ticketTimes.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                ticketTimes.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getCreatedAt())));
                ticketTimes.setUpdatedAt(updatedAt);

                ticketTimeRelation.setPerformanceId(performancesId);
                ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                ticketTimeRelation.setCreatedAt(ticketTimes.getCreatedAt());
                ticketTimeRelation.setUpdatedAt(updatedAt);

                ticketTimesMapper.delete(new UpdateWrapper<KylinTicketTimes>().eq("ticket_times_id", ticketTimes.getTicketTimesId()));
                ticketTimesMapper.insert(ticketTimes);
                ticketTimeRelationMapper.delete(new UpdateWrapper<KylinTicketTimeRelation>().eq("times_id", ticketTimeRelation.getTimesId()));
                ticketTimeRelationMapper.insert(ticketTimeRelation);

                //修改票
                for (KylinTicketPartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                    Document docTicket = mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).findOneAndUpdate(
                            Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                            objectTicketVo,
                            new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
                    );
                    KylinTicketPartnerVo kylinTicketPartnerVo = JsonUtils.fromJson(docTicket.toJson(), KylinTicketPartnerVo.class);

                    //创建演出
                    KylinTickets tickets = new KylinTickets();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, tickets);
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketStatus);
                    KylinTicketRelations ticketRelations = new KylinTicketRelations();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketRelations);

                    tickets.setPayCountdownMinute(kylinPerformanceMisVo.getPayCountdownMinute());
                    tickets.setPriceExpress(new BigDecimal("0.00"));
                    tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                    tickets.setPriceDiscount(new BigDecimal("0.00"));
                    tickets.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeStart())));
                    tickets.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEnd())));
                    if (ticketItem.getIsExpress() == 1) {
                        tickets.setTimeEndExpress(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEndExpress())));
                        tickets.setDescribeExpress(ticketItem.getDescribeExpress());
                    }
                    if (ticketItem.getIsElectronic() == 1) {
                        tickets.setDescribeElectronic(ticketItem.getDescribeElectronic());
                    }
                    tickets.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                    tickets.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                    tickets.setSaleRemindMinute(60);
                    tickets.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getCreatedAt())));
                    tickets.setUpdatedAt(updatedAt);

                    ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                    ticketStatus.setTicketId(tickets.getTicketsId());
                    ticketStatus.setIsMember(1);
                    ticketStatus.setIsExclusive(0);
                    ticketStatus.setIsTrueName(performanceStatus.getIsTrueName());
                    ticketStatus.setMemberLimitCount(1);
                    ticketStatus.setStatusExchange(7);
                    if (ticketItem.getIsShowCode() == 1) {
                        ticketStatus.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getQrCodeShowTime())));
                    }

                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                    ticketRelations.setTicketId(tickets.getTicketsId());
                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketsMapper.delete(new UpdateWrapper<KylinTickets>().eq("tickets_id", tickets.getTicketsId()));
                    ticketsMapper.insert(tickets);
                    ticketStatusMapper.delete(new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketStatus.getTicketId()));
                    ticketStatusMapper.insert(ticketStatus);
                    ticketRelationsMapper.delete(new UpdateWrapper<KylinTicketRelations>().eq("ticket_id", ticketRelations.getTicketId()));
                    ticketRelationsMapper.insert(ticketRelations);

                    dataUtils.setSurplusExchange(tickets.getTicketsId(), ticketStatus.getSurplusExchange());
                    dataUtils.setSurplusGeneral(tickets.getTicketsId(), ticketStatus.getSurplusGeneral());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    // 判断是否需要审核
    public boolean judgeIsAudit(String performanceId) {
        KylinPerformanceMisVo misVo = getPerformanceMisVo(performanceId);
        KylinPerformanceVo mongoVo = mongoVoUtils.combinePerformanceVoData(performanceId);
        if (!misVo.getTitle().equals(mongoVo.getTitle())) {
            log.debug("NEED CHANGE TITLE");
            return true;
        } if (!misVo.getImgPoster().equals(mongoVo.getImgPoster())) {
            log.debug("NEED CHANGE IMGPOSTER");
            return true;
        } else if (!misVo.getType().equals(mongoVo.getType())) {
            log.debug("NEED CHANGE TYPE");
            return true;
        } else if (!misVo.getTimeStart().equals(mongoVo.getTimeStart())) {
            log.debug("NEED CHANGE TIMESTART");
            return true;
        } else if (!misVo.getTimeEnd().equals(mongoVo.getTimeEnd())) {
            log.debug("NEED CHANGE TIMEEND");
            return true;
        } else if (!misVo.getFieldId().equals(mongoVo.getFieldId())) {
            log.debug("NEED CHANGE FIELDID");
            return true;
        } else if (!misVo.getNotice().equals(mongoVo.getNotice())) {
            log.debug("NEED CHANGE NOTICE");
            return true;
        } else if (!misVo.getDetails().equals(mongoVo.getDetails())) {
            log.debug("NEED CHANGE DETAILS");
            return true;
        } else if (!misVo.getApprovalUrl().equals(mongoVo.getApprovalUrl())) {
            log.debug("NEED CHANGE APPROVALURL");
            return true;
        } else if (!misVo.getPayCountdownMinute().equals(mongoVo.getPayCountdownMinute())) {
            log.debug("NEED CHANGE PAYCOUTDOWN");
            return true;
        }

        boolean exists = mongoTemplate.exists(Query.query(Criteria.where("status").is(-1).and("performancesId").is(performanceId)),
                KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
        if (exists) {
            log.debug("NEED CHANGE NEW TIMES");
            return true;
        }

        for (int i = 0; i < misVo.getTicketTimes().size(); i++) {
            TicketTimesTicketCreatePartnerVo times = misVo.getTicketTimes().get(i);
            KylinTicketTimesVo timesVo = mongoVo.getTicketTimeList().get(i);

            if(!times.getUseStart().equals(timesVo.getUseStart())){
                log.debug("NEED CHANGE TIMES USE_START");
                return true;
            }

            if(!times.getUseEnd().equals(timesVo.getUseEnd())){
                log.debug("NEED CHANGE TIMES USE_END");
                return true;
            }

            boolean exists2 = mongoTemplate.exists(Query.query(Criteria.where("status").is(-2).and("timesId").is(times.getTicketTimesId())), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
            if (exists2) {
                log.debug("NEED CHANGE NEW TICKET");
                return true;
            }
            for (KylinTicketPartnerVo ticketPartnerVo : times.getTicket()) {
                for (KylinTicketVo ticketVo : timesVo.getTicketList()) {
                    if (ticketVo.getTicketsId().equals(ticketPartnerVo.getTicketsId())) {
                        if (!ticketVo.getTitle().equals(ticketPartnerVo.getTitle())) {
                            log.debug("NEED CHANGE TICKET TITLE");
                            log.debug("ticketVo.getTitle() = " + ticketVo.getTitle());
                            log.debug("ticketPartnerVo.getTitle() = " + ticketPartnerVo.getTitle());
                            return true;
                        }
//                        else if (!ticketVo.getQrCodeShowTime().equals(ticketPartnerVo.getQrCodeShowTime())) {
//                            log.debug("NEED CHANGE TICKET QRCODESHOWTIME");
//                            return true;
//                    }
                        else if (!ticketVo.getDescribeElectronic().equals(ticketPartnerVo.getDescribeElectronic())) {
                            log.debug("NEED CHANGE TICKET DESCRIBEELECTRONIC");
                            log.debug("ticketVo.getDescribeElectronic() =" + ticketVo.getDescribeElectronic());
                            log.debug("ticketPartnerVo.getDescribeElectronic() =" + ticketPartnerVo.getDescribeElectronic());
                            return true;
                        } else if (!ticketVo.getDescribeExpress().equals(ticketPartnerVo.getDescribeExpress())) {
                            log.debug("NEED CHANGE TICKET DESCRIBEELEXPRESS");
                            log.debug("ticketVo.getDescribeExpress() =" + ticketVo.getDescribeExpress());
                            log.debug("ticketPartnerVo.getDescribeExpress() =" + ticketPartnerVo.getDescribeExpress());
                            return true;
                        }
                        if (!ticketVo.getDescribes().equals(ticketPartnerVo.getDescribes())) {
                            log.debug("NEED CHANGE TICKET DESCRIBES");
                            log.debug("ticketVo.getDescribes() =" + ticketVo.getDescribes());
                            log.debug("ticketPartnerVo.getDescribes() =" + ticketPartnerVo.getDescribes());
                            return true;
                        }
                        break;
                    }
                }
            }
        }
        return false;
    }
}
