package com.liquidnet.service.chime.dto;

import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: NewPageResult
 * @Package com.liquidnet.service.chime.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/13 10:49
 */

public class NewPageResult<T> implements Serializable, Cloneable {
    private static final long serialVersionUID = 8141034447809038759L;
    /**
     * 当前页数
     */
    private int currentPage = 1;
    /**
     * 每页记录数
     */
    private int pageSize = 10;

    /**
     * 总页数
     */
    private int pages;
    /**
     * 总记录数
     */
    private long total;

    private boolean isOnline;
    /**
     * 分页数据
     */
    private List<T> list;

    public NewPageResult() {
    }

    public int getPages() {
        return pages;
    }

//	public NewPageResult<T> setTotalPages(int totalPages) {
//		this.totalPages = totalPages;
//		return this;
//	}

    public long getTotal() {
        return total;
    }

    public NewPageResult<T> setTotal(long total, int pageSize) {
        this.total = total;
        if (total == -1L) {
            this.pages = 1;
        } else {
            if (pageSize > 0) {
                this.pages = (int) (total / pageSize + (total % pageSize == 0L ? 0 : 1));
            } else {
                this.pages = 0;
            }
        }
        return this;
    }

    public List<T> getList() {
        return list;
    }

    public NewPageResult<T> setList(List<T> list) {
        this.list = list;
        return this;
    }

    @Override
    public NewPageResult<T> clone() {
        try {
            return (NewPageResult<T>) super.clone();
        } catch (CloneNotSupportedException e) {
            return new NewPageResult<>();
        }
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public NewPageResult<T> setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    public int getPageSize() {
        return pageSize;
    }

    public NewPageResult<T> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public boolean isFirst()
    {
        return (this.currentPage == 1) || (this.total == 0);
    }

    public boolean isLast() {
        return (this.total == 0) || (this.currentPage >= this.pages);
    }

    public boolean isHasNext()
    {
        return this.currentPage < this.pages;
    }

    public boolean isHasPrev() {
        return this.currentPage > 1;
    }
    public Integer getNextPage()
    {
        if (this.currentPage >= this.pages) {
            return Integer.valueOf(this.pages);
        }
        return Integer.valueOf(this.currentPage + 1);
    }

    public Integer getPrevPage() {
        if (this.currentPage <= 1) {
            return Integer.valueOf(1);
        }
        return Integer.valueOf(this.currentPage - 1);
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public boolean getIsOnline() {
        return isOnline;
    }

    public void setIsOnline(boolean online) {
        isOnline = online;
    }
}

