package com.liquidnet.service.platform.service.refund;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.common.base.Joiner;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.UserPathDto;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.kylin.dto.vo.mongo.*;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.platform.utils.DataUtils;
import com.liquidnet.service.platform.utils.MongoVoUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 订单退款表 服务实现类 处理数据 退款后状态的变化
 * </p>
 *
 * @author jiaangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class KylinRefundsStatusServiceImpl {

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderTicketStatusMapper kylinOrderTicketStatusMapper;

    @Autowired
    private KylinOrderRefundsMapper kylinOrderRefundsMapper;

    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;

    @Autowired
    private KylinOrderRefundsEntitiesMapper kylinOrderRefundsEntitiesMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private MongoVoUtils mongoVoUtils;

    @Value("${liquidnet.service.candy.url}")
    private String candyUrl;

    public boolean orderTicketRefunded(RefundCallbackParam refundCallbackParam, KylinOrderRefunds refundInfo) {
        List<KylinOrderRefundEntities> refundEntities = kylinOrderRefundsEntitiesMapper.selectList(
                new QueryWrapper<KylinOrderRefundEntities>().eq("order_refunds_id", refundInfo.getOrderRefundsId())
        );
        List<String> orderTicketEntitiesIdsArr = refundEntities.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getOrderTicketEntitiesId()).collect(Collectors.toList());
        String orderTicketsId = refundInfo.getOrderTicketsId();

        KylinOrderTicketRelations orderRelations = kylinOrderTicketRelationsMapper.selectOne(
                new QueryWrapper<KylinOrderTicketRelations>().eq("order_id", orderTicketsId)
        );

        // 更新数据
        // 订单状态表
        KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
        );
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        int newStatus = 0;
        if (refundCallbackParam.getRefundPrice().add(refundInfo.getPriceCharges()).add(orderInfo.getPriceRefund()).add(orderInfo.getRefundPriceCharges()).compareTo(orderInfo.getPriceActual()) >= 0) {
            newStatus = KylinTableStatusConst.ORDER_STATUS4;
        } else {
            newStatus = KylinTableStatusConst.ORDER_STATUS6;
        }
        orderStatusTable.setStatus(newStatus);
        orderStatusTable.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketStatusMapper.update(
                orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                        .eq("order_id", orderTicketsId)
        );

        // 入场人
        BigDecimal priceActual = orderInfo.getPriceActual();
        BigDecimal priceExpress = orderInfo.getPriceExpress();
        int allEntitiesCount = kylinOrderTicketEntitiesMapper.selectCount(// 总入场人数量 排出未付款的 用来计算单入场人的价格
                new QueryWrapper<KylinOrderTicketEntities>()
                        .eq("order_id", orderTicketsId)
                        .ne("is_payment", KylinTableStatusConst.ENTITIES_IS_PAYMENT0)
        );
        BigDecimal onePrice = priceActual.subtract(priceExpress).divide(BigDecimal.valueOf(allEntitiesCount));//单价
        int refundNumber = 0;
        for (String entitiesId : orderTicketEntitiesIdsArr) {
            KylinOrderTicketEntities EntitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(//已退完成的
                    new QueryWrapper<KylinOrderTicketEntities>()
                            .eq("order_ticket_entities_id", entitiesId)
            );
            BigDecimal refundedPrice = EntitiesInfo.getRefundPrice();

            KylinOrderRefundEntities refundEntitiesInfo = kylinOrderRefundsEntitiesMapper.selectOne(
                    new QueryWrapper<KylinOrderRefundEntities>()
                            .eq("order_refunds_id", refundInfo.getOrderRefundsId())
                            .eq("order_ticket_entities_id", entitiesId)
            );

            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            BigDecimal priceNew = refundEntitiesInfo.getRefundPrice().add(refundedPrice);
            int isPayment = 0;
            if (priceNew.compareTo(onePrice) == 0) {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT3;
                refundNumber++;
            } else {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT4;
            }
            entitiesTable.setIsPayment(isPayment);
            entitiesTable.setUpdatedAt(LocalDateTime.now());
            entitiesTable.setRefundPrice(priceNew);
            Integer[] entitiesTableIsPayment = {KylinTableStatusConst.ENTITIES_IS_PAYMENT2, KylinTableStatusConst.ENTITIES_IS_PAYMENT4};
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", entitiesId)
                    .in("is_payment", entitiesTableIsPayment)
            );

            HashMap<String, Object> EntitiesVo = new HashMap<>();
            EntitiesVo.put("updatedAt", DateUtil.getNowTime());
            EntitiesVo.put("refundPrice", priceNew);
            EntitiesVo.put("isPayment", isPayment);
            BasicDBObject EntitiesVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(EntitiesVo));
            UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(entitiesId)).getQueryObject(),
                    EntitiesVov
            );

            dataUtils.delOrderTicketEntitiesRedis(entitiesId);
        }

        // 订单表
        BigDecimal price = orderInfo.getPriceRefund().add(refundCallbackParam.getRefundPrice());
        if (price.compareTo(orderInfo.getPriceActual()) == 1) {
            price = orderInfo.getPriceActual();
        }
        Integer num = orderInfo.getRefundNumber() + refundNumber;
        KylinOrderTickets update = new KylinOrderTickets();
        update.setRefundNumber(num);
        update.setPriceRefund(price);
        update.setUpdatedAt(LocalDateTime.now());
        update.setRefundPriceCharges(orderInfo.getRefundPriceCharges().add(refundInfo.getPriceCharges()));
        kylinOrderTicketsMapper.update(
                update, new UpdateWrapper<KylinOrderTickets>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        HashMap<String, Object> orderVo = new HashMap<>();
        orderVo.put("updatedAt", DateUtil.getNowTime());
        orderVo.put("priceRefund", price);
        orderVo.put("refundPriceCharges", orderInfo.getRefundPriceCharges().add(refundInfo.getPriceCharges()));
        orderVo.put("status", newStatus);
        orderVo.put("refundNumber", num);
        BasicDBObject orderVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(orderVo));
        UpdateResult orderUpdateResult = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderVov
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId, null);

        // 退款单完成
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_REFUNDED);
        kylinOrderRefunds.setRefundCode(refundCallbackParam.getRefundCode());
        kylinOrderRefunds.setRefundType(refundCallbackParam.getRefundType());
        kylinOrderRefunds.setRefundId(refundCallbackParam.getRefundId());
        kylinOrderRefunds.setRefundAt(refundCallbackParam.getRefundAt());
        kylinOrderRefunds.setUpdatedAt(LocalDateTime.now());
        kylinOrderRefundsMapper.update(
                kylinOrderRefunds,
                new UpdateWrapper<KylinOrderRefunds>().in("order_refunds_id", refundInfo.getOrderRefundsId())
        );
        // 修改缓存
        KylinOrderRefundsVo kylinOrderRefundsVo = new KylinOrderRefundsVo();
        BeanUtils.copyProperties(kylinOrderRefunds, kylinOrderRefundsVo);
        BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(kylinOrderRefundsVo));
        UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderRefundsVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderRefundsId").is(refundInfo.getOrderRefundsId())).getQueryObject(),
                object
        );
        dataUtils.delOrderRefundVo(refundInfo.getOrderRefundsId());
        dataUtils.delOrderRefundVoByOrderId(refundInfo.getOrderTicketsId());

        if (refundInfo.getType() == KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY) {
            // 退还库存
            for (String entitiesId : orderTicketEntitiesIdsArr) {
                KylinOrderTicketEntities entitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(
                        new QueryWrapper<KylinOrderTicketEntities>().eq("order_ticket_entities_id", entitiesId)
                );
                if (entitiesInfo.getIsPayment() == KylinTableStatusConst.ENTITIES_IS_PAYMENT3) {
                    dataUtils.changeSurplusGeneral(entitiesInfo.getTicketId(), 1);
                    log.info(UserPathDto.setData("changeBuyInfo", "UserId=" + orderInfo.getUserId() + "idCard=" + entitiesInfo.getEnterIdCode() + " PerformanceId=" + orderRelations.getPerformanceId() + " TicketId=" + entitiesInfo.getTicketId(), "info"));
                    dataUtils.changeBuyInfo(orderInfo.getUserId(), entitiesInfo.getEnterIdCode(), orderRelations.getPerformanceId(), entitiesInfo.getTicketId(), -1);
                }
            }
            // 退所有优惠券 提前购优惠卷不退
            KylinPerformanceVo performanceVo = dataUtils.getPerformanceVo(orderRelations.getPerformanceId());
            if (performanceVo.getIsRefundVoucher() > 0) {
                ArrayList<KylinOrderCoupons> orderCoupon = dataUtils.getOrderCoupon(orderTicketsId);
                if (!CollectionUtil.isEmpty(orderCoupon)) {
                    List<String> uCouponIds = orderCoupon.stream().filter(r -> r.getCouponType() != 101).map(KylinOrderCoupons -> KylinOrderCoupons.getCouponCode()).collect(Collectors.toList());
                    String uCouponIdsStr = Joiner.on(",").join(uCouponIds);
                    MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
                    params.add("uCouponIds", uCouponIdsStr);
                    params.add("uid", orderInfo.getUserId());

                    MultiValueMap<String, String> headers = CollectionUtil.linkedMultiValueMapStringString();
                    headers.add("Accept", "application/json;charset=UTF-8");

                    log.info("订单退款回调orderTicketRefunded-退所有优惠券：[orderTicketsId={}, [params={}, candyUrl={}]",
                            orderTicketsId, params, candyUrl);
                    String returnData = HttpUtil.post(candyUrl + "/candy-coupon/useBack", params, headers);
                    log.info("超时支付退款退券结果：{}", returnData);
                }
            }
        }

        return true;
    }

}
