package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftImageRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 18:05
 */
@ApiModel(value = "GalaxyNftImageRespDto", description = "NFT图片检测")
@Data
public class GalaxyNftImageRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "Block：建议屏蔽 Review:建议复审 Pass:建议通过")
    private String suggestion;

    @ApiModelProperty(position = 1, required = true, value = "恶意标签，Normal:正常 Porn:色情 Abuse:谩骂 Ad:广告。以及其他令人反感、不安全或不适宜的内容类型")
    private String label;

    @ApiModelProperty(position = 1, required = true, value = "机器判断当前分类的置信度，取值范围：0-100。分数越高，表示越有可能属于当前分类(如：色情99，则该样本属于色情的置信度非常高。)")
    private Integer score;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftImageRespDto obj = new GalaxyNftImageRespDto();

    public static GalaxyNftImageRespDto getNew() {
        try {
            return (GalaxyNftImageRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftImageRespDto();
        }
    }
}
