package com.liquidnet.service.goblin.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamUserProfileVo;
import com.liquidnet.service.base.ResponseDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

/**
 * @author TT
 */
@Component
@Slf4j
public class GoblinAnticipateUtils {

    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;

    private final String avatar = "";

    public String getUserInfo() {
        try {
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Authorization", "Bearer " + CurrentUtil.getToken());
            header.add("Accept", "application/json;charset=UTF-8");

            String returnData = HttpUtil.post(adamUrl + " /adam/user/info", header);
            ResponseDto<AdamUserProfileVo> innerReturnVo = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<AdamUserProfileVo>>() {
            });
            if (innerReturnVo.getData()!=null){
                return innerReturnVo.getData().getUserInfo().getAvatar();
            }
            return avatar;
        } catch (Exception e) {
            log.error("获取用户头像失败", e);
            return avatar;
        }
    }
}
