package com.liquidnet.service.galaxy;

import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftUploadReqDto;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinArtworkBiz;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestZxinArtworkBiz
 * @Package com.liquidnet.service.galaxy
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/19 16:54
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestZxinArtworkBiz {
    private static final String oldUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC001_skuId001_test/2022-03-19/ZXLNFTIMAGE202203191647596747100501.mp4";

    @Autowired
    private ZxinArtworkBiz artworkBiz;
    @Test
    public void nftUpload(){
        GalaxyNftUploadReqDto nftUploadReqDto = GalaxyNftUploadReqDto.getNew();
        nftUploadReqDto.setSkuId("video_test_001");
        nftUploadReqDto.setOriginalNftUrl(oldUrl);
        nftUploadReqDto.setRouterType(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode());
        artworkBiz.nftUpload(nftUploadReqDto);
    }
}
