package com.liquidnet.service.feign.platform.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformGoblinTaskClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformGoblinTaskClient {

    @PutMapping("ggoods/task/onshelves")
    ResponseDto<String> goodsOnShelvesHandler();

    @PutMapping("gstore/task/market/activity")
    ResponseDto<String> storeMarketActivityHandler();

    @PostMapping("spu/goblin/setCount")
    ResponseDto<String> setCount();

    @PostMapping("codeTask/generateCode")
    ResponseDto<String> codeCount();


    @GetMapping("task/nft/order/notPayNum")
    ResponseDto<String> getNotPayNum();
}
