package com.liquidnet.service.adam.controller.admin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.service.admin.IAdamMemberAdminService;
import com.liquidnet.service.adam.service.admin.IAdamMemberCodeAdminService;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order = 90060)
@Api(tags = "后台管理:会员信息")
@Slf4j
@RestController
@RequestMapping("/admin/member")
public class AdamMemberAdminController {
    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    IAdamMemberCodeAdminService adamMemberCodeAdminService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加会员")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamMemberParam parameter) {
        return ResponseDto.success(adamMemberService.add(parameter));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "生成兑换码")
    @PostMapping("gen_code")
    public ResponseDto<String> genMemberCode(@RequestBody AdamMemberCodeParam parameter) {

        return ResponseDto.success(adamMemberCodeAdminService.createGiftCode(parameter));
    }
}
