package com.liquidnet.service.goblin.param.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 后台管理NFT订单管理搜索参数
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-01
 */

@Data
public class GoblinNftOrderListParam {
    @ApiModelProperty(value = "页数", example = "1")
    private Integer pageSize;
    @ApiModelProperty(value = "数量", example = "20")
    private Integer pageNum;

    @ApiModelProperty(value = "藏品名称")
    private String name;
    @ApiModelProperty(value = "用户ID")
    private String userId;
    @ApiModelProperty(value = "短订单编号")
    private String shortOrderCode;
    @ApiModelProperty(value = "订单编号")
    private String orderCode;
    @ApiModelProperty(value = "哈希值")
    private String nftId;
    @ApiModelProperty(value = "购买方式")
    private Integer orderType;
    @ApiModelProperty(value = "支付方式")
    private String payType;
    @ApiModelProperty(value = "订单状态")
    private Integer status;
    @ApiModelProperty(value = "支付开始时间")
    private String payTimeStart;
    @ApiModelProperty(value = "支付结束时间")
    private String payTimeEnd;
}
