package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 推荐活动表
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRecommendActiveVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long mid;

    /**
     * 推荐活动id
     */
    @ApiModelProperty(value = "推荐活动id")
    private String recommendId;

    /**
     * 开启时间
     */
    @ApiModelProperty(value = "开启时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime endTime;

    /**
     * 1NFT2组合购3演出4商品
     */
    @ApiModelProperty(value = "1NFT2组合购3演出4商品")
    private Integer activeType;

    /**
     * 活动绑定id
     */
    @ApiModelProperty(value = "活动绑定id")
    private String activeBindId;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "0未删除1已删除")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "0未删除1已删除")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    /**
     * 0开启，1未开启
     */
    @ApiModelProperty(value = "0开启，1未开启")
    private Integer status;


    @ApiModelProperty(value = "推荐活动")
    private List<KylinRecommendActiveRelationVo> list;

    @ApiModelProperty(value = "演出的vo")
    private KylinPerformanceVo kylinPerformanceVo;

    private Object goblinNftGoodsSkuInfoVo;

    private Object goblinGoodsInfoVo;

    private Object goblinMixAppDetailsVo;

    private String name;
    private static final KylinRecommendActiveVo obj = new KylinRecommendActiveVo();
    public static KylinRecommendActiveVo getNew() {
        try {
            return (KylinRecommendActiveVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinRecommendActiveVo();
        }
    }
}
