package com.liquidnet.service.sweet.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * YB报名表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-07-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetYbActivityVo implements Serializable {

    private static final long serialVersionUID = -2081186417971841992L;

    @ApiModelProperty(value = "活动id")
    private String activityId;

    @ApiModelProperty(value = "活动名称")

    private String title;

    @ApiModelProperty(value = "封面图")
    private String cover;

    @ApiModelProperty(value = "状态[0-未开始|6-开始|7-下线|9-结束]")
    private Integer status;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    @ApiModelProperty(value = "更新时间")
    private String updatedAt;

    private static final SweetYbActivityVo obj = new SweetYbActivityVo();

    public static SweetYbActivityVo getNew() {
        try {
            return (SweetYbActivityVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetYbActivityVo();
        }
    }

}
