package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 演出状态
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinPerformanceStatus implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * performance_status_id
     */
    private String performanceStatusId;

    /**
     * 演出关联id
     */
    private String performanceId;

    /**
     * 是否显示 0全部用户不可见 1全部可见 2白名单可见
     */
    private Integer isShow;

    /**
     * 状态:-1删除;0未提交;1审核中;2审核中（自动上线）;3审核通过;4审核未通过;6上线;7下架;8活动结束;9活动取消退款中;10活动取消退
     */
    private Integer status;

    /**
     * 是否售卖 0停止 1正常
     */
    private Integer statusSell;

    /**
     * 是否开启分销 0关闭 1开启
     */
    private Integer isDistribution;

    /**
     * 是否关联小程序 0不关联 1关联
     */
    private Integer syncAgent;

    /**
     * 是否同步大麦 0不关联 1关联
     */
    private Integer syncDamai;

    /**
     * -1未提交审核，0提交审核，1审核通过，2审核拒绝
     */
    private Integer auditStatus;

    /**
     * 是否实名 0不需要 1需要
     */
    private  Integer isTrueName;

    /**
     * 限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)
     */
    private Integer limitCount;

    /**
     * 实名限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)
     */
    private Integer idCount;

    /**
     * 会员限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)
     */
    private Integer limitCountMember;

    /**
     * 推荐顺序 0不推荐
     */
    private Integer isRecommend;

    /**
     * 是否开启退款比例 0否 1是
     */
    private Integer isOpenRefundPresent;

    /**
     * 是否支持退款 0否 1是
     */
    private Integer isCanRefund;

    /**
     * 退款开始时间
     */
    private LocalDateTime refundOpenTime;

    /**
     * 退款结束时间
     */
    private LocalDateTime refundCloseTime;

    /**
     * 是否有手续费
     */
    private Integer isRefundPoundage;

    /**
     * 用户退款快递票是否需要自己支付快递费 1用户承担寄付 0公司月结
     */
    private Integer isRefundExpress;

    /**
     * 快递票是否需要退回
     */
    private Integer isBackPaperTicket;

    /**
     * 用户退款快递票是否退快递费 1退回 0不退回
     */
    private Integer isRefundExpressNew;

    /**
     * 是否退优惠券
     * 这个是前后台通用的配置 其他都是针对用户自己退款的
     */
    private Integer isRefundVoucher;

    /**
     * 是否开启转赠 0否 1是
     */
    private Integer isTransfer;

    /**
     * 转赠开始时间
     */
    private LocalDateTime transferStartTime;

    /**
     * 转赠结束时间
     */
    private LocalDateTime transferEndTime;

    /**
     * 是否需要场地审核
     */
    private Integer fieldAuditStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinPerformanceStatus obj = new KylinPerformanceStatus();
    public static KylinPerformanceStatus getNew() {
        try {
            return (KylinPerformanceStatus) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinPerformanceStatus();
        }
    }

    public Object[] insert(KylinPerformanceStatus vo){
        return new Object[]{
                vo.getPerformanceStatusId(),vo.getPerformanceId(),
                vo.getIsShow(),vo.getStatus(),vo.getStatusSell(),
                vo.getIsDistribution(),vo.getSyncAgent(),0,
                vo.getAuditStatus(),vo.getIsTrueName(),vo.getLimitCount(),
                vo.getLimitCountMember(),vo.getFieldAuditStatus(),vo.getCreatedAt(),vo.getUpdatedAt()
        };
    }
}
