package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Api
@Data
public class CouponOutLineVo implements Serializable, Cloneable {
    @ApiModelProperty(dataType = "String", name = "storeCouponIds", value = "券ID",example = "1",required = true)
    private String storeCouponId;
    @ApiModelProperty(dataType = "Integer", name = "count", value = "折扣[例如95折]",example = "95",required = true)
    private Integer discount;
    @ApiModelProperty(dataType = "String", name = "name", value = "券名称",example = "券名称1",required = true)
    private String name;
    @ApiModelProperty(dataType = "String", name = "desc", value = "描述",example = "这是95折券",required = true)
    private String desc;
    @ApiModelProperty(value = "券类型[1-代金券|2-折扣券|3-满减券]", example = "1")
    private String couType;

    private static final CouponOutLineVo obj = new CouponOutLineVo();

    public static CouponOutLineVo getNew() {
        try {
            return (CouponOutLineVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponOutLineVo();
    }
}
