package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinGoodsTagVo", description = "商品关联标签信息")
@Data
public class GoblinGoodsTagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2342407105969740471L;
    @ApiModelProperty(position = 11, value = "标签ID")
    private String tagId;
    @ApiModelProperty(position = 12, value = "标签名称")
    private String tagName;
    @ApiModelProperty(position = 13, value = "标签图片")
    private String tagPic;
    @ApiModelProperty(position = 14, value = "排序[数值越小,排序越前]")
    private Integer sort;

    public GoblinGoodsTagVo setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    private static final GoblinGoodsTagVo obj = new GoblinGoodsTagVo();
    public static GoblinGoodsTagVo getNew() {
        try {
            return (GoblinGoodsTagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsTagVo();
        }
    }

    public GoblinGoodsTagVo copy(GoblinSelfTagVo source) {
        if (null == source) return this;
        this.setTagId(source.getTagId());
        this.setTagName(source.getTagName());
        this.setTagPic(source.getTagPic());
        return this;
    }
}
