package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.goblin.dto.admin.GoblinNftOrderListDto;
import com.liquidnet.service.goblin.dto.admin.GoblinNftOrderRefundListDto;
import com.liquidnet.service.goblin.entity.GoblinNftOrder;
import com.liquidnet.service.goblin.mapper.GoblinNftOrderMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftOrderRefundMapper;
import com.liquidnet.service.goblin.param.admin.GoblinNftOrderListParam;
import com.liquidnet.service.goblin.param.admin.GoblinNftOrderRefundListParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * NFT订单管理实现
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-30
 */
@Service
public class GoblinNftOrderAdminServiceImpl extends ServiceImpl<GoblinNftOrderMapper, GoblinNftOrder> {

    @Autowired
    private GoblinNftOrderMapper orderMapper;
    @Autowired
    private GoblinNftOrderRefundMapper refundMapper;

    public List<GoblinNftOrderListDto> orderList(GoblinNftOrderListParam listParam) {
        try {
            List<GoblinNftOrderListDto> voList = orderMapper.searchList(BeanUtil.convertBeanToMap(listParam));
            return voList;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    public PageInfo<GoblinNftOrderRefundListDto> refundList(GoblinNftOrderRefundListParam listParam) {
        PageInfo<GoblinNftOrderRefundListDto> pageInfoTmp = null;
        try {
            PageHelper.startPage(listParam.getPageNum(), listParam.getPageSize());
            List<GoblinNftOrderRefundListDto> voList = refundMapper.searchList(BeanUtil.convertBeanToMap(listParam));
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }
}
