package com.liquidnet.service.platform.service.impl.adam;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.dto.vo.AdamProPerformMarkVo;
import com.liquidnet.service.adam.dto.vo.AdamProScanitVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.platform.utils.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.ArrayList;

@Service
public class PlatformAdamUserProService extends ServiceImpl<AdamUserMapper, AdamUser> {
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public AdamProScanitVo scanitProcess(String pid, String pna, String cod) {

        AdamProScanitVo scanitVo = AdamProScanitVo.getNew();
        scanitVo.setNickname("nk");
        scanitVo.setMobile("13700000000");
        scanitVo.setStageMarker(11);

        ArrayList<AdamProPerformMarkVo> performMarkVoArrayList = ObjectUtil.getAdamProPerformMarkVoArrayList();
        AdamProPerformMarkVo performMarkVo = AdamProPerformMarkVo.getNew();
        performMarkVo.setPid("1");
        performMarkVo.setPname("aname");
        performMarkVo.setTime(DateUtil.Formatter.yyyy_MM_dd.format(LocalDate.now()));
        performMarkVo.setCount(1);
        performMarkVoArrayList.add(performMarkVo);
        scanitVo.setPerformMarkVos(performMarkVoArrayList);

        return scanitVo;
    }
}
