package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 单品关联规格值
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSkuSpecValue implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 商品id，对应 goblin_goods.spu_id
     */
    private String spuId;

    /**
     * 单品id，对应 goblin_goods_sku.sku_id
     */
    private String skuId;

    /**
     * 规格id，对应 goblin_goods_spec.spec_id
     */
    private String specId;

    /**
     * 规格值id，对应 goblin_goods_spec_value.spec_vid
     */
    private String specVid;

    /**
     * 规格值
     */
    private String valueRemark;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;


}
