package com.liquidnet.service.order.utils;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * <p>
 * xx 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2024-08-09 13:37
 */
@Component
@Slf4j
public class ValidationUtils {
    public static boolean isAnyFieldNull(Object obj, String... excludeFields) {
        if (obj == null) {
            return true;
        }

        try {
            for (Field field : obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                boolean isExcluded = false;
                for (String excludeField : excludeFields) {
                    if (field.getName().equals(excludeField)) {
                        isExcluded = true;
                        break;
                    }
                }
                if (!isExcluded && value == null) {
                    return true;
                }
            }
        } catch (IllegalAccessException e) {
            log.error("isAnyFieldNull,e:{}", e);
            e.printStackTrace();
        }

        return false;
    }

    /*public static void main(String[] args) {
        AddressVo addressVo = new AddressVo();
        addressVo.setAddress("111");
        addressVo.setCountyId("111");
        addressVo.setName("111");
        addressVo.setPhone("111");
        addressVo.setCity("111");
        addressVo.setCounty("111");
        addressVo.setProvince("111");
        boolean isAnyFieldNull = isAnyFieldNull(addressVo, "countyId", "name");
        System.out.println(isAnyFieldNull);
    }*/


}
