package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "AdamMemberOrderCallbackResult", description = "购买会员或会员码的支付回调")
@Data
public class AdamMemberOrderCallbackResult implements Serializable {
    private static final long serialVersionUID = 3219448286221952517L;

    @ApiModelProperty(position = 0, required = true, value = "订单状态")
    private Integer status;
    @ApiModelProperty(position = 1, required = true, value = "订单号")
    private String orderCode;
    @ApiModelProperty(position = 2, required = true, value = "支付单号")
    private String code;
    @ApiModelProperty(position = 3, required = true, value = "购买类型")
    private String type;
    @ApiModelProperty(position = 4, required = true, value = "金额")
    private BigDecimal price;
    @ApiModelProperty(position = 5, required = true, value = "支付类型")
    private String paymentType;
    @ApiModelProperty(position = 6, required = true, value = "支付时间")
    private LocalDateTime paymentAt;
}
