package com.liquidnet.service.kylin.utils;

import com.liquidnet.common.exception.LiquidnetServiceException;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Component
public class QueueUtils {

    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * 发送 SqlMapping Json 字符串
     *
     * @param exchange 交换机
     * @param route    路径
     * @param sqlStr   Json字符串
     */
    public void sendSqlRabbit(String exchange, String route, String sqlStr) {
            rabbitTemplate.convertAndSend(exchange, route, sqlStr);
    }

    /**
     * 给 REDIS 队列发送消息 数据库相关
     *
     * @param redisKey RedisKey 消费Key
     * @param sqlStr   Json字符串
     * @return
     */
    public void sendSqlRedis(String redisKey, String sqlStr) {
            HashMap<String, String> map = new HashMap<>();
            map.put("message", sqlStr);
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey(redisKey);
            stringRedisTemplate.opsForStream().add(record);
    }
}
