package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.dto.nft.Nft032SeriesResp;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTradeQuery;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinTradeQueryBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 17:38
 */
@Slf4j
@Component
public class ZxinTradeQueryBiz implements IGalaxyRouterStrategyTradeQuery {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Override
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getMessage());
        }
        if(StringUtil.isEmpty(nftOrderBo.getNftId())){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getMessage());
        }

        Nft036InfoReqDto nft036InfoReqDto = Nft036InfoReqDto.getNew();
        nft036InfoReqDto.setNftId(nftOrderBo.getNftId());
        ZxlnftResponseDto<Nft036InfoRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft036Info(nft036InfoReqDto);
        //查询结果
        GalaxyQueryNftInfoRespDto queryNftInfoRespDto = GalaxyQueryNftInfoRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData().getNftInfo(),queryNftInfoRespDto);
            return ResponseDto.success(queryNftInfoRespDto);
        }
        return ResponseDto.failure();
    }

    @Override
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryTransNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyQueryNftTradeListRespDto> queryNftTradeList(GalaxyQueryNftTradeListReqDto reqDto) {
//        //获取订单信息
//        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.());
//        if(StringUtil.isNull(nftOrderBo)){
//            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getMessage());
//        }
//        if(StringUtil.isEmpty(nftOrderBo.getNftId())){
//            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getMessage());
//        }

        Nft039TradeListReqDto nft039TradeListReqDto = Nft039TradeListReqDto.getNew();
        nft039TradeListReqDto.setNftId(reqDto.getNftId());
        nft039TradeListReqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft039TradeListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft039TradeList(nft039TradeListReqDto);
        //查询结果
        GalaxyQueryNftTradeListRespDto queryNftTradeListRespDto = GalaxyQueryNftTradeListRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData(),queryNftTradeListRespDto);
            return ResponseDto.success(queryNftTradeListRespDto);
        }
        return ResponseDto.failure();
    }

    @Override
    public ResponseDto<GalaxyQuerySeriesInfoRespDto> querySeriesInfo(GalaxyQuerySeriesInfoReqDto reqDto) {
        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNull(seriesNftInfoBo)){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
        }

        Nft032SeriesReqDto nft032SeriesReqDto = Nft032SeriesReqDto.getNew();
        nft032SeriesReqDto.setSeriesId(seriesNftInfoBo.getSeriesId());
        ZxlnftResponseDto<Nft032SeriesRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft032Series(nft032SeriesReqDto);
        //查询结果
        GalaxyQuerySeriesInfoRespDto querySeriesInfoRespDto = GalaxyQuerySeriesInfoRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            Nft032SeriesResp.SeriesInfo seriesInfo = zxlnftResponseDto.getData().getSeriesInfo();
            BeanUtil.copy(seriesInfo,querySeriesInfoRespDto);
            querySeriesInfoRespDto.setTotalCount(seriesInfo.getTotalCount().toString());
            querySeriesInfoRespDto.setSeriesBeginFromZero(Boolean.toString(seriesInfo.isSeriesBeginFromZero()));
            querySeriesInfoRespDto.setCrtCount(seriesInfo.getCrtCount().toString());
            querySeriesInfoRespDto.setCreateTimeStamp(seriesInfo.getCreateTimeStamp().toString());
            return ResponseDto.success(querySeriesInfoRespDto);
        }
        return ResponseDto.failure();
    }

    @Override
    public ResponseDto<GalaxyQueryUserSeriesNftListRespDto> queryUserSeriesNftList(GalaxyQueryUserSeriesNftListReqDto reqDto) {
        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());

        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNull(seriesNftInfoBo)){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
        }

        Nft037AddressListReqDto nft037ReqDto = Nft037AddressListReqDto.getNew();
        nft037ReqDto.setAddr(userInfoBo.getBlockChainAddress());
        nft037ReqDto.setSeriesId(seriesNftInfoBo.getSeriesId());
        nft037ReqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft037AddressListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft037AddressList(nft037ReqDto);


        GalaxyQueryUserSeriesNftListRespDto queryNftListRespDto = GalaxyQueryUserSeriesNftListRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData(),queryNftListRespDto);
            queryNftListRespDto.setUserId(reqDto.getUserId());
            queryNftListRespDto.setSeriesId(seriesNftInfoBo.getSeriesId());
        }else{
            return ResponseDto.failure();
        }
        return ResponseDto.success(queryNftListRespDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeAllListRespDto> queryUserTradeAllList(GalaxyQueryUserTradeAllListReqDto reqDto) {
        Nft042TradeAllListReqDto nft042TradeAllListReqDto = Nft042TradeAllListReqDto.getNew();
        nft042TradeAllListReqDto.setAddr(reqDto.getBlockChainAddress());
        nft042TradeAllListReqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft042TradeAllListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft042TradeAllList(nft042TradeAllListReqDto);

        GalaxyQueryUserTradeAllListRespDto queryUserTradeAllListRespDto = GalaxyQueryUserTradeAllListRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData(),queryUserTradeAllListRespDto);
        }else{
            return ResponseDto.failure();
        }
        return ResponseDto.success(queryUserTradeAllListRespDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeInListRespDto> queryUserTradeInList(GalaxyQueryUserTradeInListReqDto reqDto) {
        Nft040TradeInListReqDto nft040TradeInListReqDto = Nft040TradeInListReqDto.getNew();
        nft040TradeInListReqDto.setAddr(reqDto.getBlockChainAddress());
        nft040TradeInListReqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft040TradeInListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft040TradeInList(nft040TradeInListReqDto);

        GalaxyQueryUserTradeInListRespDto queryUserTradeInListRespDto = GalaxyQueryUserTradeInListRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData(),queryUserTradeInListRespDto);
        }else{
            return ResponseDto.failure();
        }
        return ResponseDto.success(queryUserTradeInListRespDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeOutListRespDto> queryUserTradeOutList(GalaxyQueryUserTradeOutListReqDto reqDto) {
        Nft041TradeOutListReqDto nft041TradeOutListReqDto = Nft041TradeOutListReqDto.getNew();
        nft041TradeOutListReqDto.setAddr(reqDto.getBlockChainAddress());
        nft041TradeOutListReqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft041TradeOutListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft041TradeOutList(nft041TradeOutListReqDto);

        GalaxyQueryUserTradeOutListRespDto queryUserTradeOutListRespDto = GalaxyQueryUserTradeOutListRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData(),queryUserTradeOutListRespDto);
        }else{
            return ResponseDto.failure();
        }
        return ResponseDto.success(queryUserTradeOutListRespDto);
    }
}
