package com.liquidnet.service.consumer.kylin.receiver;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class ConsumerGoblinPhoneCodeReceiver extends AbstractBizRedisReceiver{

    @Autowired
    private GoblinNftExCodeMapper goblinNftExCodeMapper;
    @Value("${liquidnet.service.order.url}")
    private String orderUrl;

    @Override
    protected boolean consumerMessageHandler(String msg) {
        Boolean bol = false;
        try{
            JSONObject jsonObject = JSON.parseObject(msg);
            String codestr = jsonObject.getString("codes");
            String userIds = jsonObject.getString("userIds");
            String adminUid = jsonObject.getString("adminUid");
            List<String> codeList =  Arrays.asList(codestr.split(","));
            List<String> userIdList = Arrays.asList(userIds.split(","));


            StringBuffer codes = new StringBuffer();
            for (int i = 0; i < userIdList.size(); i++) {
                MultiValueMap<String, String> params = new LinkedMultiValueMap();
                params.add("code", codeList.get(i));
                params.add("userId", userIdList.get(i));
                MultiValueMap<String, String> headers = CollectionUtil.linkedMultiValueMapStringString();
                headers.add("Accept", "application/json;charset=UTF-8");
                headers.add("Authorization", "Bearer " + CurrentUtil.getToken());
                String post = HttpUtil.post(orderUrl + "/order/goblin/nft/airdrop", params, headers);
                ResponseDto<Boolean> rsp = JsonUtils.fromJson(post, new TypeReference<ResponseDto<Boolean>>() {
                });
                if (rsp.isSuccess()) {
                    codes.append(codeList.get(i)).append(",");
                }
            }
            if (StringUtil.isNotBlank(codes)){
                codes.deleteCharAt(codes.length()-1);
            }
            goblinNftExCodeMapper.updateCodeAdminUids(codes.toString(),adminUid);
        }catch (Exception e){
            e.printStackTrace();
            log.error("发送空投失败!");
        }
        return bol;
    }

    @Override
    protected String getRedisStreamKey() {
        return MQConst.GoblinQueue.GOBLIN_PHONE_CODE_OPERA.getKey();
    }

    @Override
    protected String getRedisStreamGroup() {
        return MQConst.GoblinQueue.GOBLIN_PHONE_CODE_OPERA.getGroup();
    }
}
