package com.liquidnet.commons.lang.util;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public class CurrentUtil {
    public static final String CK_ENV_ACTIVE = "spring.profiles.active";
    public static final String GRAY_LOGIN_SMS_CODE = "111111";

    /* ======================================================= | */
    public static final String uToken = "authorization";
    public static final String uTag = "u-tag";

    public static final String TOKEN_SUB = "sub";
    public static final String TOKEN_MOBILE = "mobile";
    public static final String TOKEN_NICKNAME = "nickname";
    public static final String TOKEN_TYPE = "type";
    public static final String TOKEN_UCREATED = "c_at";
    public static final String TOKEN_TYPE_VAL_USER = "user";
    public static final String TOKEN_TYPE_VAL_STATION = "station";

    public static final String HEADER_CLI_SOURCE = "source";
    public static final String HEADER_CLI_VERSION = "version";
    public static final String HEADER_CLI_UNKNOWN = "unknown";

    private static final String IP_UTILS_FLAG = ",";
    private static final String LOCALHOST_IP = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP1 = "127.0.0.1";

    public static String getToken() {
        return StringUtils.defaultIfEmpty((String) ServletUtils.getRequest().getAttribute(uToken), "");
    }

    public static Map getTokenClaims() {
        return JsonUtils.fromJson((String) ServletUtils.getRequest().getAttribute(CurrentUtil.uTag), Map.class);
    }

    public static String getCurrentUid() {
        return (String) ServletUtils.getRequest().getAttribute(TOKEN_SUB);
    }

    public static String getCurrentSlimeUid() {
        if("582251359821905923484786".equals(ServletUtils.getRequest().getAttribute(TOKEN_SUB))){
            return "245754392713379846109548";
        }
        return (String) ServletUtils.getRequest().getAttribute(TOKEN_SUB);
    }

    public static String getHeaderCliSource() {
        return ServletUtils.getRequest().getHeader(HEADER_CLI_SOURCE);
    }

    public static String getHeaderCliVersion() {
        return ServletUtils.getRequest().getHeader(HEADER_CLI_VERSION);
    }

    public static String getCliIpAddr() {
        HttpServletRequest request = ServletUtils.getRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || HEADER_CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || HEADER_CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || HEADER_CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || HEADER_CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || HEADER_CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
//            if (LOCALHOST_IP1.equalsIgnoreCase(ip) || LOCALHOST_IP.equalsIgnoreCase(ip)) {
//                // 根据网卡取本机配置的IP
//                InetAddress iNet = null;
//                try {
//                    iNet = InetAddress.getLocalHost();
//                } catch (UnknownHostException e) {
//                    e.printStackTrace();
//                }
//                ip = iNet.getHostAddress();
//            }
        }
        // 使用代理，则获取第一个IP地址
        if (!StringUtils.isEmpty(ip) && ip.indexOf(IP_UTILS_FLAG) > 0) {
            ip = ip.substring(0, ip.indexOf(IP_UTILS_FLAG));
        }
        return LOCALHOST_IP.equals(ip) ? LOCALHOST_IP1 : ip;
    }
}
