package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinZhengzaiAppVersionsServiceImpl;
import com.liquidnet.service.kylin.dao.ZhengzaiAppVersionsListDao;
import com.liquidnet.service.kylin.dto.param.ZhengzaiAppVersionsParam;
import com.liquidnet.service.kylin.dto.param.admin.ZhengzaiAppVersionsSearchParam;
import com.liquidnet.service.kylin.dto.vo.admin.ZhengzaiAppVersionsVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 正在现场app版本控制
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-11
 */

@Controller
@RequestMapping("/kylin/zhengzaiAppVersion")
public class ZhengzaiAppVersionController extends BaseController {

    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;

    @Value("${liquidnet.al-oss.appUrl}")
    private String appUrl;

    private String prefix = "zhengzai/kylin/zhengzaiAppVersion";

    @Autowired
    private KylinZhengzaiAppVersionsServiceImpl kylinZhengzaiAppVersionsServiceImpl;

    @GetMapping("/create")
    public String create(ModelMap mmap) {
        mmap.put("platformUrl", platformUrl);
        return prefix + "/create";
    }

    @RequiresPermissions("kylin:zhengzaiAppVersion:create")
    @PostMapping("create")
    @ResponseBody
    public AjaxResult createSave(ZhengzaiAppVersionsParam zhengzaiAppVersionsParam) {
        Boolean res = kylinZhengzaiAppVersionsServiceImpl.create(zhengzaiAppVersionsParam);
        if (res) {
            return success();
        } else {
            return error("添加失败");
        }
    }

    @GetMapping("/update/{zhengzaiAppVersionsId}")
    public String update(@PathVariable("zhengzaiAppVersionsId") String zhengzaiAppVersionsId, ModelMap mmap) {
        ZhengzaiAppVersionsVo result = null;
        result = kylinZhengzaiAppVersionsServiceImpl.detail(zhengzaiAppVersionsId);

        mmap.put("ZhengzaiAppVersionsVo", result);
        mmap.put("platformUrl", platformUrl);

        return prefix + "/update";
    }

    @RequiresPermissions("kylin:zhengzaiAppVersion:update")
    @PostMapping("update")
    @ResponseBody
    public AjaxResult updateSave(ZhengzaiAppVersionsParam zhengzaiAppVersionsParam) {
        boolean res = kylinZhengzaiAppVersionsServiceImpl.update(zhengzaiAppVersionsParam);
        if (res) {
            return success();
        } else {
            return error("修改失败");
        }
    }

    @RequiresPermissions("kylin:zhengzaiAppVersion:view")
    @GetMapping()
    public String zhengzaiAppVersions() {
        return prefix + "/zhengzaiAppVersion";
    }

    @RequiresPermissions("kylin:zhengzaiAppVersion:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo allList(ZhengzaiAppVersionsSearchParam zhengzaiAppVersionsSearchParam) {
        PageInfo<ZhengzaiAppVersionsListDao> result = kylinZhengzaiAppVersionsServiceImpl.listInfo(zhengzaiAppVersionsSearchParam);
        return getDataTable(result.getList());
    }

    @RequiresPermissions("kylin:zhengzaiAppVersion:delete")
    @PostMapping("delete")
    @ResponseBody
    public AjaxResult delete(ZhengzaiAppVersionsParam zhengzaiAppVersionsParam) {
        List<String> bannersId = zhengzaiAppVersionsParam.getIds();
        boolean result = kylinZhengzaiAppVersionsServiceImpl.delete(bannersId);
        if (result) {
            return success("删除成功");
        } else {
            return error("删除失败");
        }
    }

}
