package com.liquidnet.common.third.shumei.util;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.common.third.shumei.biz.ShumeiBiz;
import com.liquidnet.common.third.shumei.constant.ShumeiConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 数美工具类
 * @class: ShumeiUtil
 * @Package com.liquidnet.common.third.shumei.util
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/7 17:46
 */
@Slf4j
@Component
public class ShumeiUtil {
    @Autowired
    private ShumeiBiz shumeiBiz;

    public boolean checkText(String userId,String text){
        log.info("ShumeiUtil.checkText userId:{} text:{}",userId,text);
        try {
            JSONObject result = shumeiBiz.checkText(userId,text);
            log.info("checkText result :{} ",result);
            if (result != null) {
                log.info("checkText result code:{} ",result.get("code"));
                if (result.get("code").toString().equals(ShumeiConstant.ResponseCodeEnum.SUCCESS.getCode())) {
                    String riskLevel = result.get("riskLevel").toString();
                    log.info("checkText result riskLevel:{} ",riskLevel);
                    if(riskLevel.equalsIgnoreCase(ShumeiConstant.RiskLevelEnum.PASS.getCode())){
                        return true;
                    }
                }
            }else{
                log.error("checkText result is null:{} ",result);
            }
        } catch (Exception e) {
            log.error("ShumeiUtil.checkText error userId:{} text:{}",userId,text);
            log.error("ShumeiUtil.checkText error msg:{}",e.getMessage());
            return false;
        }
        return false;
    }

    public boolean checkImage(String userId,String imageUrl){
        log.info("ShumeiUtil.checkText userId:{} imageUrl:{}",userId,imageUrl);
        try {
            JSONObject result = shumeiBiz.checkImage(userId,imageUrl);
            log.info("checkText result :{} ",result);
            if (result != null) {
                log.info("checkText result code:{} ",result.get("code"));
                if (result.get("code").toString().equals(ShumeiConstant.ResponseCodeEnum.SUCCESS.getCode())) {
                    String riskLevel = result.get("riskLevel").toString();
                    String requestId = result.get("requestId").toString();
                    String riskDescription = result.get("riskDescription").toString();
                    log.info("checkText result riskLevel:{} ",riskLevel);
                    log.info("checkText result requestId:{} ",requestId);
                    log.info("checkText result riskDescription:{} ",riskDescription);
                    if(riskLevel.equalsIgnoreCase(ShumeiConstant.RiskLevelEnum.PASS.getCode())){
                        return true;
                    }
                }
            }else{
                log.error("checkText result is null:{} ",result);
            }
        } catch (Exception e) {
            log.error("ShumeiUtil.checkText error userId:{} text:{}",userId,imageUrl);
            log.error("ShumeiUtil.checkText error msg:{}",e.getMessage());
            return false;
        }
        return false;
    }
}