package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetWechatTemplateServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "公众号模版消息")
@RestController
@RequestMapping("/wechatTemplate")
public class SweetWechatTemplateController {

    @Autowired
    private SweetWechatTemplateServiceImpl sweetTemplateService;

    @GetMapping("send")
    @ApiOperation("发送模版消息")
    public ResponseDto send() {
        return sweetTemplateService.sendRemindMsg();
    }

    @PostMapping("remind")
    @ApiOperation("提醒记录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "openId", value = "微信openId", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "unionId", value = "微信unionId", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performancesId", value = "演出ID", required = true),
    })
    public ResponseDto remind(
            @RequestParam() String openId,
            @RequestParam() String unionId,
            @RequestParam() String performancesId
    ) {
        return sweetTemplateService.remind(openId, unionId, performancesId);
    }

    @PostMapping("followStatus")
    @ApiOperation("获取关注状态")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "unionId", value = "微信unionId", required = true),
    })
    public ResponseDto followStatus(
            @RequestParam() String unionId
    ) {
        boolean status = sweetTemplateService.followStatus(unionId);
        if (status) {
            return ResponseDto.success(1);
        } else {
            return ResponseDto.success(2);
        }
    }

}
