package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftBuyPayResultQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 11:23
 */
@ApiModel(value = "GalaxyNftBuyPayResultQueryRespDto", description = "NFT购买支付结果查询")
@Data
public class GalaxyNftBuyPayResultQueryRespDto implements Serializable,Cloneable {

    /**
     * 标记任务状态，0：任务执行中 1：任务成功 2：任务失败
     */
    @ApiModelProperty(position = 3, required = true, value = "标记任务状态，0：任务执行中 1：任务成功 2：任务失败")
    private Integer taskStatus;

    /**
     * 失败情况下会有提示信息
     */
    @ApiModelProperty(position = 3, required = true, value = "失败情况下会有提示信息")
    private String taskMsg;

    /**
     * 交易hash
     */
    @ApiModelProperty(position = 3, required = true, value = "交易hash")
    private String txHash;

    /**
     * 链上交易时间戳
     */
    @ApiModelProperty(position = 3, required = true, value = "chainTimestamp")
    private Long chainTimestamp;

    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftBuyPayResultQueryRespDto obj = new GalaxyNftBuyPayResultQueryRespDto();

    public static GalaxyNftBuyPayResultQueryRespDto getNew() {
        try {
            return (GalaxyNftBuyPayResultQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftBuyPayResultQueryRespDto();
        }
    }
}
